/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.hkn.services;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.hkn.BankBusinessConfig;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import sun.net.www.protocol.https.Handler;

public class DBS_DC_Packer {
    public static JSONObject createHeader(String accNo, String country) {
        JSONObject header = new JSONObject();
        header.put("msgId", (Object)Sequence.genSequence());
        header.put("orgId", (Object)BankBusinessConfig.getCompanyId(accNo));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        header.put("timeStamp", (Object)format.format(new Date()));
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
        if (null == code && (code = ISOCountryUtils.getInstance().getCountryInfo(country)) == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56fd\u5bb6\u7801\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"DBS_DC_Packer_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), country));
        }
        String accCtry = BankBusinessConfig.getAccCtry(accNo);
        if (StringUtils.isEmpty((String)accCtry)) {
            header.put("ctry", (Object)code.geteChart2());
        } else {
            header.put("ctry", (Object)accCtry);
        }
        return header;
    }

    public static String packAck(PaymentInfo info) {
        Element simulator = new Element("simulator");
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"token", (String)"");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)info.getBankDetailSeqID());
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"itemSequence", (String)info.getBankDetailSeqId());
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public static HttpsURLConnection createConnection(String uri, String accNo) throws KeyManagementException, IOException, NoSuchAlgorithmException {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        String timeOut = RequestContextUtils.getBankParameterValue((String)"timeout");
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        URL urlStr = new URL("https", ip, Integer.parseInt(port), uri);
        URL url = new URL(null, urlStr.toString(), new Handler());
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(sc.getSocketFactory());
        conn.setDoInput(true);
        conn.setConnectTimeout(2000);
        conn.setReadTimeout(Integer.parseInt(timeOut) * 60 * 1000);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setRequestProperty("x-api-key", BankBusinessConfig.getApiKeyId(accNo));
        conn.setRequestProperty("X-DBS-ORG_ID", BankBusinessConfig.getCompanyId(accNo));
        conn.connect();
        return conn;
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

