/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qlb.dc.service.payment.sameBank;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qlb.dc.service.QLB_Packer;
import kd.ebg.aqap.banks.qlb.dc.service.payment.PayPacker;
import kd.ebg.aqap.banks.qlb.dc.service.payment.PayParser;
import kd.ebg.aqap.banks.qlb.dc.service.payment.QueryPay;
import kd.ebg.aqap.banks.qlb.dc.service.utils.SignHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPay.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.createSameBankPaymentMessage((PaymentInfo)bankPayRequest.getPaymentInfos().get(0));
    }

    private String createSameBankPaymentMessage(PaymentInfo paymentInfo) throws EBServiceException {
        Element root = QLB_Packer.createCommonHead("CBE003", paymentInfo.getPackageId());
        Element ReqParam = root.getChild("opReq").getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)ReqParam, (String)"payAmount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"remarks", (String)PayPacker.addKDFlag(paymentInfo));
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved2", (String)"");
        String xmlMsg = JDomUtils.root2String((Element)root, (String)"GBK");
        SignHelper signHelper = new SignHelper();
        String signData = signHelper.sign(xmlMsg);
        return QLB_Packer.packRequestMsg("CBE003", signData);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String response) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PayParser parser = new PayParser();
        parser.parsePay(paymentInfos, response);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-qlb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/yqbank/APIQLReqServlet");
    }
}

