/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.batch.other;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.BatchPayPacker;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.other.QueryPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.salary.SalaryDetailHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryParser;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String bizSeqId = bankPayRequest.getHeader().getBizSeqID();
        String batchId = paymentInfo.getBankBatchSeqId();
        String fileContent = BatchPayPacker.packUploadFile(bankPayRequest.getPaymentInfoAsArray(), "IBAF04");
        try {
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + batchId + "");
            new ABC_DCFileUtil().uploadFile(batchId, fileContent, bizSeqId);
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.logger.info(fileContent);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6:%1$s\u5931\u8d25\u3002", (String)"SalaryPayImpl_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), batchId), (Throwable)e);
        }
        String accNo = paymentInfo.getAccNo();
        Element root = ABC_DC_Packer.createABCRoot4New("IBAF04", batchId);
        JDomUtils.addChild((Element)root, (String)"Amt", (String)SalaryDetailHelper.getTotalAmount(bankPayRequest.getPaymentInfos()));
        JDomUtils.addChild((Element)root, (String)"FileFlag", (String)"1");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(accNo));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"SumNum", (String)(bankPayRequest.getPaymentInfos().size() + ""));
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)batchId);
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)corp, (String)"DbLogAccNo", (String)"");
        JDomUtils.addChild((Element)corp, (String)"NFAccNo", (String)BankBusinessConfig.getIBAF04NFAccNo(accNo));
        JDomUtils.addChild((Element)corp, (String)"NVoucherType", (String)BankBusinessConfig.getIBAF04NVoucherType(accNo));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo[] infos = paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]);
        new SalaryParser().parsePay(infos, responseStr);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "IBAF04";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u672c\u884c\u6c47\u603b\u6279\u91cf\u4ee3\u53d1\uff08\u5b9e\u65f6\uff09", (String)"IBAF04PaymentImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

