/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.srcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.srcb.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.srcb.dc.services.detail.DetailImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class SrcbDcMetaDataImpl
extends OPAMetaDataTemplate {
    public static final String InstId = "InstId";
    public static final String InstName = "InstName";
    public static final String CertId = "CertId";
    public static final String BankCertId = "BankCertId";
    public static final String AppId = "AppId";
    public static final String AppSecret = "AppSecret";
    public static final String SM2_Private_Key = "sm2_private_key";
    public static final String SM2_Bank_Public_Key = "sm2_bank_public_key";
    public static final String SM2_Custom_Key = "sm2_custom_key";
    public static final String SM2_Bank_Key = "sm2_bank_key";

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTPS");
        this.setTimeOut(3);
        this.setCharSet("UTF-8");
        this.setUri("/frontend/channel/branch/bank-api-3");
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u6df1\u5733\u519c\u6751\u5546\u4e1a\u94f6\u884c\u3002", (String)"SrcbDcMetaDataImpl_0", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
        this.setBankVersionID("SRCB_DC");
        this.setBankShortName("SRCB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u6df1\u5733\u519c\u6751\u5546\u4e1a\u94f6\u884c\u94f6\u653f\u76f4\u8054\u7248", (String)"SrcbDcMetaDataImpl_1", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u6df1\u5733\u519c\u6751\u5546\u4e1a\u94f6\u884c\u94f6\u653f\u76f4\u8054\u7248", (String)"SrcbDcMetaDataImpl_1", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.PGP_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        return loginConfigs;
    }

    private List<BankLoginConfig> getBankPGPConfig() {
        BankLoginConfig sm2Pri = BankLoginConfigUtil.getMlBankLoginConfig((String)SM2_Private_Key, (MultiLangEnumBridge)new MultiLangEnumBridge("\u56fd\u5bc6\u7b7e\u540d\u79c1\u94a5", "SrcbDcMetaDataImpl_2", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        sm2Pri.setDesc(new MultiLangEnumBridge("\u5ba2\u6237\u81ea\u5df1\u7684\u56fd\u5bc6\u79c1\u94a5\uff0c\u8bf7\u6c42\u62a5\u6587\u7b7e\u540d\u65f6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002", "SrcbDcMetaDataImpl_3", "ebg-aqap-banks-srcb-dc"));
        BankLoginConfig sm2Pub = BankLoginConfigUtil.getMlBankLoginConfig((String)SM2_Bank_Public_Key, (MultiLangEnumBridge)new MultiLangEnumBridge("\u56fd\u5bc6\u9a8c\u7b7e\u516c\u94a5", "SrcbDcMetaDataImpl_4", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        sm2Pub.setDesc(new MultiLangEnumBridge("\u94f6\u884c\u7684\u56fd\u5bc6\u516c\u94a5\uff0c\u7ebf\u4e0b\u4ea4\u6362\u7ed9\u5ba2\u6237\u81ea\u5df1\u4fdd\u5b58\uff0c\u5bf9\u54cd\u5e94\u62a5\u6587\u8fdb\u884c\u9a8c\u7b7e\u65f6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002", "SrcbDcMetaDataImpl_5", "ebg-aqap-banks-srcb-dc"));
        BankLoginConfig sm2Custom = BankLoginConfigUtil.getMlBankLoginConfig((String)SM2_Custom_Key, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u89e3\u5bc6\u79c1\u94a5", "SrcbDcMetaDataImpl_6", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        sm2Custom.setDesc(new MultiLangEnumBridge("\u5ba2\u6237\u81ea\u5df1\u7684\u89e3\u5bc6\u79c1\u94a5\uff0c\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\u65f6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002", "SrcbDcMetaDataImpl_7", "ebg-aqap-banks-srcb-dc"));
        BankLoginConfig sm2Bank = BankLoginConfigUtil.getMlBankLoginConfig((String)SM2_Bank_Key, (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u52a0\u5bc6\u516c\u94a5", "SrcbDcMetaDataImpl_8", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        sm2Bank.setDesc(new MultiLangEnumBridge("\u94f6\u884c\u7684\u52a0\u5bc6\u516c\u94a5\uff0c\u8bf7\u6c42\u62a5\u6587\u52a0\u5bc6\u65f6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002", "SrcbDcMetaDataImpl_9", "ebg-aqap-banks-srcb-dc"));
        return Lists.newArrayList((Object[])new BankLoginConfig[]{sm2Pri, sm2Pub, sm2Custom, sm2Bank});
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)InstId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u673a\u6784ID", "SrcbDcMetaDataImpl_10", "ebg-aqap-banks-srcb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7531\u6df1\u519c\u5546\u4e2d\u95f4\u4e1a\u52a1\u7cfb\u7edf\u7edf\u4e00\u9881\u53d1\u3002", "SrcbDcMetaDataImpl_11", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)InstName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u673a\u6784\u540d\u79f0", "SrcbDcMetaDataImpl_12", "ebg-aqap-banks-srcb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bf7\u6c42\u65b9\u673a\u6784\u540d\u79f0", "SrcbDcMetaDataImpl_13", "ebg-aqap-banks-srcb-dc"), (String)""), BankLoginConfigUtil.getMlBankLoginConfig((String)CertId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u7684\u8bc1\u4e66ID", "SrcbDcMetaDataImpl_14", "ebg-aqap-banks-srcb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7531\u6df1\u519c\u5546\u4e2d\u95f4\u4e1a\u52a1\u7cfb\u7edf\u7edf\u4e00\u5206\u914d\u3002", "SrcbDcMetaDataImpl_15", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)BankCertId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u7684\u8bc1\u4e66ID\u3002", "SrcbDcMetaDataImpl_16", "ebg-aqap-banks-srcb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7531\u6df1\u519c\u5546\u4e2d\u95f4\u4e1a\u52a1\u7cfb\u7edf\u7edf\u4e00\u5206\u914d\u3002", "SrcbDcMetaDataImpl_15", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)AppId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5e94\u7528ID", "SrcbDcMetaDataImpl_17", "ebg-aqap-banks-srcb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7cfb\u7edf\u63a5\u5165\u65f6\uff0c\u7531\u6df1\u519c\u5546\u9881\u53d1\u3002", "SrcbDcMetaDataImpl_18", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)AppSecret, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5e94\u7528\u5bc6\u94a5", "SrcbDcMetaDataImpl_19", "ebg-aqap-banks-srcb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7cfb\u7edf\u63a5\u5165\u65f6\uff0c\u7531\u6df1\u519c\u5546\u9881\u53d1\uff0c\u767b\u5f55\u83b7\u53d6\u4ee4\u724c\u63a5\u53e3\u4f7f\u7528\u3002", "SrcbDcMetaDataImpl_20", "ebg-aqap-banks-srcb-dc"), (String)"", (boolean)false, (boolean)false)});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{BalanceImpl.class, DetailImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("TranDate", DetailUniqueTypeEnum.STRING.getType());
        result.put("TranTime", DetailUniqueTypeEnum.STRING.getType());
        result.put("LoanFlag", DetailUniqueTypeEnum.STRING.getType());
        result.put("Amount", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }

    public boolean showInJdy() {
        return false;
    }
}

