/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc.services.utils;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.ebg.aqap.banks.srcb.dc.services.utils.CryptoException;
import kd.ebg.aqap.banks.srcb.dc.services.utils.KeyUtil;

public class BaseAsymmetric<T extends BaseAsymmetric<T>> {
    protected String algorithm;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    protected final Lock lock = new ReentrantLock();

    public BaseAsymmetric(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.init(algorithm, privateKey, publicKey);
    }

    protected T init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.algorithm = algorithm;
        if (null == privateKey && null == publicKey) {
            this.initKeys();
        } else {
            if (null != privateKey) {
                this.privateKey = privateKey;
            }
            if (null != publicKey) {
                this.publicKey = publicKey;
            }
        }
        return (T)this;
    }

    public T initKeys() {
        KeyPair keyPair = KeyUtil.generateKeyPair(this.algorithm);
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        return (T)this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public T setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return (T)this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public T setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return (T)this;
    }

    public T setKey(Key key) {
        if (key instanceof PublicKey) {
            return this.setPublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.setPrivateKey((PrivateKey)key);
        }
        throw new CryptoException("Unsupported key type: {}", key.getClass());
    }
}

