/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc.services.utils;

import java.util.Base64;
import java.util.regex.Pattern;

public class SecureUtil {
    public static byte[] decode(String key) {
        Pattern pattern = Pattern.compile("^[a-f0-9]+$", 2);
        boolean isHex = pattern.matcher(key).matches();
        if (isHex) {
            return SecureUtil.decodeHex(key.toCharArray());
        }
        return Base64.getDecoder().decode(key);
    }

    public static byte[] decodeHex(char[] hexData) {
        int len = hexData.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = SecureUtil.toDigit(hexData[j], j) << 4;
            f |= SecureUtil.toDigit(hexData[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

