/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc.services.utils;

import kd.ebg.aqap.banks.srcb.dc.services.utils.BCUtil;
import kd.ebg.aqap.banks.srcb.dc.services.utils.GetStore;
import kd.ebg.aqap.banks.srcb.dc.services.utils.SM2;
import kd.ebg.egf.common.utils.crypto.HexUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;

public class SmUtil {
    public static final String SM2_CURVE_NAME = "sm2p256v1";
    public static final ECDomainParameters SM2_DOMAIN_PARAMS = BCUtil.toDomainParams(GMNamedCurves.getByName((String)"sm2p256v1"));
    private static final int RS_LEN = 32;

    public static String sign(String message) {
        String sm2PrivateKey = GetStore.getSm2PrivateKey();
        sm2PrivateKey = StrUtil.removeAll((CharSequence)sm2PrivateKey, (char[])new char[]{' '});
        SM2 sm2 = SmUtil.sm2(HexUtil.decodeHex((String)sm2PrivateKey), null);
        byte[] sign = sm2.sign(message.getBytes());
        String signHexStr = HexUtil.encodeHexStr((byte[])sign);
        String len = StrUtil.padPre((CharSequence)String.valueOf(signHexStr.length()), (int)8, (char)'0');
        return len + signHexStr + message;
    }

    public static boolean verify(String message) {
        String sm2BankPublicKey = GetStore.getSm2BankPublicKey();
        sm2BankPublicKey = StrUtil.removeAll((CharSequence)sm2BankPublicKey, (char[])new char[]{' '});
        SM2 sm2 = SmUtil.sm2(null, HexUtil.decodeHex((String)sm2BankPublicKey));
        int len = Integer.parseInt(message.substring(0, 8));
        String sign = message.substring(8, len + 8);
        String realMessage = message.substring(len + 8);
        return sm2.verify(realMessage.getBytes(), HexUtil.decodeHex((String)sign));
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        return new SM2(privateKey, publicKey);
    }
}

