/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srb.cmp.services.payment.salary;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.srb.cmp.services.utils.Common;
import kd.ebg.aqap.banks.srb.cmp.services.utils.FileUtil;
import kd.ebg.aqap.banks.srb.cmp.services.utils.Packer;
import kd.ebg.aqap.banks.srb.cmp.services.utils.ParserUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QrySalaryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QrySalaryPaymentImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String tr_code = "200201";
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        String serialNo = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"SRBSerialNo");
        LocalDateTime submitSuccessTime = paymentInfo.getSubmitSuccessTime();
        if (StringUtils.isEmpty((String)serialNo)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7serial_no\u4e3a\u7a7a\u3002", (String)"QrySalaryPaymentImpl_7", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]));
        }
        if (submitSuccessTime == null) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671ftr_acdt\u4e3a\u7a7a\u3002", (String)"QrySalaryPaymentImpl_8", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serialNo);
        String d = submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)d);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        log.info("---\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2---");
        log.info("---\u9700\u8981\u67e5\u8be2\u7684\u5355\u636e\u4fe1\u606f\uff1a" + paymentInfos.toString());
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String content;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QrySalaryPaymentImpl_0", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u8bb0\u5f55\u6761\u6570=%s\u3002", (String)"QrySalaryPaymentImpl_6", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), record_num), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        if ("1".equals(file_flag)) {
            log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = new FileUtil().downloadFile(file_name);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (String)"QrySalaryPaymentImpl_2", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u7684\u5177\u4f53\u5185\u5bb9\uff1a" + content);
        String[][] rs = this.parseRecord(content, recordNum, fieldNum);
        for (int i = 0; i < rs.length; ++i) {
            log.info(String.valueOf(Arrays.asList(rs[i])));
            String ACNO = rs[i][1];
            String ACNAME = rs[i][3];
            String AMT = rs[i][5];
            String STAT = rs[i][9];
            String ERR_MSG = rs[i][10];
            String BATCH_NO = rs[i][11];
            PaymentInfo payInfo = this.findPaymentInfo(paymentInfos, BATCH_NO, ACNO, ACNAME, AMT);
            if (null == payInfo) {
                log.info("\u94f6\u884c\u8fd4\u56de\u7b2c{}\u6761\u6570\u636e\u672a\u88ab\u5339\u914d", (Object)i);
                continue;
            }
            ParserUtil.handlePayStatus(payInfo, STAT, ERR_MSG);
        }
        ParserUtil.processingBankItemDataHandler(rs);
        PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos, (boolean)false, (boolean)false);
        return new EBBankPayResponse(paymentInfos);
    }

    public PaymentInfo findPaymentInfo(List<PaymentInfo> infos, String BATCH_NO, String ACNO, String ACNAME, String AMT) {
        String packageId = infos.get(0).getPackageId();
        for (PaymentInfo pay : infos) {
            BigDecimal amount;
            if (!packageId.equals(BATCH_NO) || !pay.getIncomeAccNo().equals(ACNO) || !pay.getIncomeAccName().equals(ACNAME) || !StringUtils.isNotEmpty((String)AMT) || (amount = new BigDecimal(AMT)).compareTo(pay.getAmount()) != 0) continue;
            return pay;
        }
        return null;
    }

    public String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        log.info("###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2] fieldNum =" + fieldNum + ", recordNum =" + recordNum + ", allrecord.length =" + allrecord.length);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return null;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

