/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.bochk.dc.services.balance.RegionBalanceImpl;
import kd.ebg.aqap.banks.bochk.dc.services.balance.RegionHisBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class RouteBalance
extends AbstractBalanceImpl
implements IBalance,
IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RouteBalance.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        EBBankBalanceResponse response;
        logger.info("====\u4f59\u989d\u67e5\u8be2\u8def\u7531====");
        ArrayList<BalanceInfo> total = new ArrayList<BalanceInfo>(1);
        MappingAcctService service = MappingAcctService.getInstance();
        ArrayList<BankAcnt> proxyAcnts = new ArrayList<BankAcnt>(1);
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        for (BankAcnt acnt : request.getBankAcntList()) {
            if (BankBusinessConfig.getBOC_HK_OTHER_OR_SELF_QRY() || service.isExist(acnt.getAccNo())) {
                proxyAcnts.add(acnt);
                continue;
            }
            bankAcnts.add(acnt);
        }
        logger.info("\u4ee3\u7406\u67e5\u8be2\u8d26\u6237:" + proxyAcnts.size());
        logger.info("\u672c\u884c\u8d26\u6237:" + bankAcnts.size());
        if (!proxyAcnts.isEmpty()) {
            request.setBankAcntList(proxyAcnts);
            response = LocalDate.now().isEqual(request.getEndDate()) ? new RegionBalanceImpl().balance(request) : new RegionHisBalanceImpl().hisBalance(request);
            total.addAll(response.getBalances());
        }
        if (!bankAcnts.isEmpty()) {
            request.setBankAcntList(bankAcnts);
            if (LocalDate.now().isEqual(request.getEndDate())) {
                response = new BalanceImpl().balance(request);
                total.addAll(response.getBalances());
            } else {
                for (BankAcnt acnt : bankAcnts) {
                    BalanceInfo balanceInfo = new BalanceInfo();
                    balanceInfo.setBankAcnt(acnt);
                    balanceInfo.setBankCurrency(request.getBankCurrency());
                    balanceInfo.setError(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"RouteBalance_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
                    total.add(balanceInfo);
                }
            }
        }
        return new EBBankBalanceResponse(total);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public LocalDate limitDate() {
        return LocalDate.now().minusDays(364L);
    }

    public String getDeveloper() {
        return "0xC";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8def\u7531\u5230\u4f59\u989d\u67e5\u8be2\u7684\u63a5\u53e3\u3002", (String)"RouteBalance_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public boolean async() {
        return false;
    }
}

