/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRemarksUtils {
    private static final String FILENAME = "transactionRemarksCode.xls";
    private static Logger logger = LoggerFactory.getLogger(TransactionRemarksUtils.class);
    private static Map<String, Map<String, String>> codeMap;
    private static TransactionRemarksUtils utils;

    public static TransactionRemarksUtils getInstance() {
        return utils;
    }

    public String getTransactionRemark(String businessType, String bankVersion) {
        Map<String, String> map;
        if (!StringUtils.isEmpty((String)businessType) && !StringUtils.isEmpty((String)bankVersion) && (map = codeMap.get(businessType)) != null) {
            for (Map.Entry<String, String> entries : map.entrySet()) {
                String key = entries.getKey();
                if (key.indexOf(bankVersion) == -1) continue;
                return entries.getValue();
            }
        }
        return "";
    }

    static {
        utils = new TransactionRemarksUtils();
        codeMap = new HashMap<String, Map<String, String>>(16);
        HashMap<String, String> value = new HashMap<String, String>(16);
        value.put(ResManager.loadKDString((String)"\u4e2d\u94f6\u9999\u6e2f(BOCHK_DC)", (String)"TransactionRemarksUtils_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "4");
        value.put(ResManager.loadKDString((String)"\u6e23\u6253\u94f6\u884c(SCB_H2H)", (String)"TransactionRemarksUtils_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "CCDN");
        value.put(ResManager.loadKDString((String)"\u6c47\u4e30\u94f6\u884c(HSBC_DC)", (String)"TransactionRemarksUtils_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "/BUSINESS/CHARITY DONATION");
        codeMap.put("Charity Donation", value);
        value = new HashMap(16);
        value.put(ResManager.loadKDString((String)"\u4e2d\u94f6\u9999\u6e2f(BOCHK_DC)", (String)"TransactionRemarksUtils_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "6");
        value.put(ResManager.loadKDString((String)"\u6e23\u6253\u94f6\u884c(SCB_H2H)", (String)"TransactionRemarksUtils_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "REMT");
        value.put(ResManager.loadKDString((String)"\u6c47\u4e30\u94f6\u884c(HSBC_DC)", (String)"TransactionRemarksUtils_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "");
        codeMap.put("Cross-border Payment\uff08individual\uff09", value);
        value = new HashMap(16);
        value.put(ResManager.loadKDString((String)"\u4e2d\u94f6\u9999\u6e2f(BOCHK_DC)", (String)"TransactionRemarksUtils_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "1");
        value.put(ResManager.loadKDString((String)"\u6e23\u6253\u94f6\u884c(SCB_H2H)", (String)"TransactionRemarksUtils_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "CGOD");
        value.put(ResManager.loadKDString((String)"\u6c47\u4e30\u94f6\u884c(HSBC_DC)", (String)"TransactionRemarksUtils_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "/BUSINESS/GOODS TRADE");
        codeMap.put("Cross Border Goods Trade", value);
        value = new HashMap(16);
        value.put(ResManager.loadKDString((String)"\u4e2d\u94f6\u9999\u6e2f(BOCHK_DC)", (String)"TransactionRemarksUtils_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "2");
        value.put(ResManager.loadKDString((String)"\u6e23\u6253\u94f6\u884c(SCB_H2H)", (String)"TransactionRemarksUtils_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "CSTR");
        value.put(ResManager.loadKDString((String)"\u6c47\u4e30\u94f6\u884c(HSBC_DC)", (String)"TransactionRemarksUtils_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "/BUSINESS/SERVICE TRADE");
        codeMap.put("Cross Border Service Trade", value);
        value = new HashMap(16);
        value.put(ResManager.loadKDString((String)"\u4e2d\u94f6\u9999\u6e2f(BOCHK_DC)", (String)"TransactionRemarksUtils_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "5");
        value.put(ResManager.loadKDString((String)"\u6e23\u6253\u94f6\u884c(SCB_H2H)", (String)"TransactionRemarksUtils_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "COCA");
        value.put(ResManager.loadKDString((String)"\u6c47\u4e30\u94f6\u884c(HSBC_DC)", (String)"TransactionRemarksUtils_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "/BUSINESS/CURRENT ACC TXN");
        codeMap.put("Other Current Account Transactions", value);
        value = new HashMap(16);
        value.put(ResManager.loadKDString((String)"\u4e2d\u94f6\u9999\u6e2f(BOCHK_DC)", (String)"TransactionRemarksUtils_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "3");
        value.put(ResManager.loadKDString((String)"\u6e23\u6253\u94f6\u884c(SCB_H2H)", (String)"TransactionRemarksUtils_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "CCTF");
        value.put(ResManager.loadKDString((String)"\u6c47\u4e30\u94f6\u884c(HSBC_DC)", (String)"TransactionRemarksUtils_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), "/BUSINESS/CAPITAL TRF");
        codeMap.put("Cross Border Capital Transfer", value);
    }
}

