/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Constants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CIB_DC_Parser
implements CIB_DC_Constants {
    public static Element parseString2Root(String rspStr) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        return root;
    }

    public static BankResponse parseResponse(Element root) throws EBServiceException {
        BankResponse rsp = new BankResponse();
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("XPMTTRNRS");
        Element pub = eb.getChild("STATUS");
        String recode = pub.getChildTextTrim("CODE");
        String reMessage = pub.getChildTextTrim("MESSAGE");
        String errorMessage = pub.getChildText("MESSAGE");
        rsp.setResponseCode(recode);
        if (StringUtils.isEmpty((String)reMessage)) {
            rsp.setResponseMessage(errorMessage);
        } else {
            rsp.setResponseMessage(reMessage);
        }
        return rsp;
    }

    public static void checkRspCode(BankResponse rsp, String successCode) throws EBServiceException {
        if (!successCode.equalsIgnoreCase(rsp.getResponseCode())) {
            String bankName = RequestContextUtils.getRequestContext().getAcnt().getBankName();
            String bizName = RequestContextUtils.getRequestContext().getBizNameCN();
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s%2$S\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%3$s", (String)"CIB_DC_Parser_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), bankName, bizName, StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode()}), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
    }
}

