/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.balancereconciliation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceStatementImpl.class);

    public int getMonthSpan() {
        return 1;
    }

    public String pack(BankBalanceStatementRequest request) {
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element in = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element ct = JDomUtils.addChild((Element)in, (String)"CHECKACCTDETAILQUERYTRNRQ");
        String packageID = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)ct, (String)"TRNUID", (String)packageID);
        Element rqbody = JDomUtils.addChild((Element)ct, (String)"RQBODY");
        rqbody.setAttribute("PAGE", "1");
        rqbody.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)rqbody, (String)"RECONCILE_DATE", (String)request.getStartMonth());
        JDomUtils.addChild((Element)rqbody, (String)"SIGN_ACCOUNT", (String)request.getAccNo());
        JDomUtils.addChild((Element)rqbody, (String)"CURRENCY", (String)request.getCurrency());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest request, String s) {
        ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(1);
        Element root = CIB_DC_Parser.parseString2Root(s);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("CHECKACCTDETAILQUERYTRNRS");
        Element rsbody = eb.getChild("RSBODY");
        String bill_no = rsbody.getChildText("BILL_NO");
        String reconcile_date = rsbody.getChildText("RECONCILE_DATE");
        List items = rsbody.getChildren("ITEMS");
        if (CollectionUtil.isEmpty((Collection)items)) {
            this.logger.info("{}\u6ca1\u6709\u8bb0\u5f55\u3002", (Object)request.getStartMonth());
            return new EBBankBalanceStatementResponse(detailList);
        }
        for (Element item : items) {
            String bank_balance = item.getChildText("BANK_BALANCE");
            String accNo = item.getChildText("RECONCILE_ACCOUNT");
            String currency = item.getChildText("RECONCILE_ACCOUNT_CURRENCY");
            BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
            detail.setAccNo(accNo);
            detail.setCurrency(currency);
            detail.setMonth(reconcile_date);
            detail.setBalance(bank_balance);
            detail.setStatementNo(bill_no);
            detailList.add(detail);
        }
        return new EBBankBalanceStatementResponse(detailList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CHECKACCTDETAILQUERYTRNRQ";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankBalanceStatementRequest request) {
        return true;
    }
}

