/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.allocation;

import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class PayParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(PayParser.class);

    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("XPMTTRNRS");
        String packageId = eb.getChildText("TRNUID");
        Element pub = eb.getChild("STATUS");
        String recode = pub.getChildTextTrim("CODE");
        this.log.info("return code:" + recode);
        String reMessage = pub.getChildTextTrim("MESSAGE");
        String errorMessage = pub.getChildText("MESSAGE");
        String bankCode = recode;
        String bankMsg = StringUtils.isEmpty((String)reMessage) ? errorMessage : reMessage;
        String responseCode = null;
        String responseMsg = null;
        String xferprCode = null;
        if ("0".equalsIgnoreCase(recode)) {
            String message;
            Element xpmtrs = eb.getChild("XPMTRS");
            Element er = xpmtrs.getChild("XFERPRCSTS");
            xferprCode = er.getChildText("XFERPRCCODE");
            responseMsg = message = er.getChildText("MESSAGE");
            responseCode = "0".equalsIgnoreCase(recode) ? xferprCode : ("10514".equalsIgnoreCase(recode) ? "AUDITING" : "FAIL");
        }
        if (!StringUtils.isEmpty(responseMsg)) {
            bankMsg = responseMsg;
        }
        if (!StringUtils.isEmpty(xferprCode)) {
            bankCode = xferprCode;
        }
        if ("PAYOUT".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)"", (String)bankCode, (String)bankMsg);
        } else if ("AUDITING".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankCode, (String)bankMsg);
            this.log.info(responseMsg);
        } else if ("FAIL".equalsIgnoreCase(responseCode) || "CANCEL".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentFailState((PaymentInfo)paymentInfos[0], (String)"", (String)bankCode, (String)bankMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankCode, (String)bankMsg);
        }
    }
}

