/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker
implements Constants {
    public static String packPay(PaymentInfo[] paymentInfos, String code) throws EBServiceException {
        boolean isReimed;
        PaymentInfo info = paymentInfos[0];
        Element root = Packer.createMessageWithHead(code);
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)xdataBody, (String)"PayerAcNo", (String)paymentInfos[0].getAccNo());
        String type = "1";
        String usage = "4111";
        boolean bl = isReimed = info.getUseCN().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT")) || !StringUtils.isEmpty((String)info.getExplanation()) && info.getExplanation().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT"));
        if (isReimed) {
            type = "2";
            usage = ExplanationUtil.convertExplToBank(info.getExplanation(), info.getAmount());
        }
        JDomUtils.addChild((Element)xdataBody, (String)"payType", (String)type);
        JDomUtils.addChild((Element)xdataBody, (String)"totalRow", (String)("" + paymentInfos.length));
        BigDecimal total = PayPacker.getTotalAmt(paymentInfos);
        JDomUtils.addChild((Element)xdataBody, (String)"totalAmt", (String)BigDecimalHelper.plain2((BigDecimal)total));
        JDomUtils.addChild((Element)xdataBody, (String)"fileContent", (String)PayPacker.getFileContent(paymentInfos, usage));
        JDomUtils.addChild((Element)xdataBody, (String)"Usage", (String)usage);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String getFileContent(PaymentInfo[] infos) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < infos.length; ++i) {
            PayPacker.app(buffer, infos[i].getIncomeAccNo());
            PayPacker.app(buffer, infos[i].getIncomeAccName());
            String explanation = infos[i].getExplanation();
            PayPacker.app(buffer, PayPacker.formatString(explanation, 20));
            PayPacker.app(buffer, BigDecimalHelper.plain2((BigDecimal)infos[i].getAmount()));
            PayPacker.appEnd(buffer, infos[i].getBankDetailSeqId());
            if (i == infos.length - 1) continue;
            String LINE_SEP = "^";
            buffer.append(LINE_SEP);
        }
        return buffer.toString();
    }

    public static String getFileContent(PaymentInfo[] infos, String usage) {
        boolean localFlag = BankBusinessConfig.isCyberFlag();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < infos.length; ++i) {
            String explanation;
            PayPacker.app(buffer, infos[i].getIncomeAccNo());
            PayPacker.app(buffer, infos[i].getIncomeAccName());
            if (infos[i].is2SameBank()) {
                explanation = infos[i].getExplanation();
                PayPacker.app(buffer, PayPacker.formatString(explanation, 20));
                PayPacker.app(buffer, BigDecimalHelper.plain2((BigDecimal)infos[i].getAmount()));
                PayPacker.appEnd(buffer, infos[i].getBankDetailSeqId());
            } else {
                PayPacker.app(buffer, usage);
                explanation = infos[i].getExplanation();
                PayPacker.app(buffer, PayPacker.formatString(explanation, 20));
                if (UseConvertor.isSalary((PaymentInfo)infos[i])) {
                    PayPacker.app(buffer, "11");
                    PayPacker.app(buffer, PayPacker.getSettNo(infos[i].getIncomeBankName(), infos[i].getIncomeCnaps()));
                } else if (localFlag) {
                    PayPacker.app(buffer, "11");
                    PayPacker.app(buffer, PayPacker.getSettNo(infos[i].getIncomeBankName(), infos[i].getIncomeCnaps()));
                } else {
                    PayPacker.app(buffer, infos[i].getAmount().compareTo(new BigDecimal("1000000")) <= 0 ? "6" : "7");
                    PayPacker.app(buffer, infos[i].getIncomeCnaps());
                }
                PayPacker.app(buffer, infos[i].getBankDetailSeqId());
                PayPacker.appEnd(buffer, BigDecimalHelper.plain2((BigDecimal)infos[i].getAmount()));
            }
            if (i == infos.length - 1) continue;
            String LINE_SEP = "^";
            buffer.append(LINE_SEP);
        }
        return buffer.toString();
    }

    public static String getSettNo(String incomeBankName, String defaultValue) {
        SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
        String recBankNo = settBankKeyWordsRepository.matchBankNoByKey(incomeBankName);
        if (StringUtils.isEmpty((String)recBankNo)) {
            return defaultValue;
        }
        return recBankNo;
    }

    private static void app(StringBuilder buffer, String field) {
        String FILED_SEP = "|";
        buffer.append(PayPacker.filter(field)).append(FILED_SEP);
    }

    private static void appEnd(StringBuilder buffer, String field) {
        buffer.append(PayPacker.filter(field));
    }

    private static String filter(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        data = StringUtils.replace((String)data, (String)"|", (String)"-");
        data = StringUtils.replace((String)data, (String)"^", (String)"-");
        return data;
    }

    private static BigDecimal getTotalAmt(PaymentInfo[] paymentInfos) {
        BigDecimal total = BigDecimalHelper.ZERO;
        for (int i = 0; i < paymentInfos.length; ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfos[i].getAmount());
        }
        return total;
    }

    private static String formatString(String string, int length) {
        if (StringUtils.isEmpty((String)string)) {
            return "";
        }
        if (string.length() > length) {
            return string.substring(0, length);
        }
        return string;
    }
}

