/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.company;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.company.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.company.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.company.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl
implements INativeLinkPayable {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "Xfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u4ea4\u6613(Xfer)", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && UseConvertor.isTransfer((PaymentInfo)paymentInfo)) {
            AcntHelp.checkAccCity(paymentInfo);
            paymentInfo.setIndividual(Boolean.valueOf(false));
            return true;
        }
        if ("pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !UseConvertor.isSalary((PaymentInfo)paymentInfo) && !BankBusinessConfig.isVirtualAccount(paymentInfo.getAccNo()) && !paymentInfo.is2Individual()) {
            AcntHelp.checkAccCity(paymentInfo);
            paymentInfo.setIndividual(Boolean.valueOf(false));
            paymentInfo.setPackageKey("accNo=" + paymentInfo.getAccNo());
            return !BankBusinessConfig.isUseOnlinePay() && !BankBusinessConfig.isCompany2Batch();
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        return PayPacker.packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
    }
}

