/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.sub;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.sub.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.sub.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.sub.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "CostReimbGroup";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0d\u4fee\u6539", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equalsIgnoreCase(subBizType)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            return paymentInfo.is2SameBank() && BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo());
        }
        if ("pay".equalsIgnoreCase(subBizType) && UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            return paymentInfo.is2SameBank() && BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo());
        }
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !UseConvertor.isSalary((PaymentInfo)paymentInfo) && !UseConvertor.isTransfer((PaymentInfo)paymentInfo) && !BankBusinessConfig.isVirtualAccount(paymentInfo.getAccNo()) && paymentInfo.is2Individual() && !BankBusinessConfig.isUseOnlinePay() && paymentInfo.is2SameBank() && BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo());
    }

    public String pack(BankPayRequest request) {
        return PayPacker.packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
    }
}

