/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.virtual;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.virtual.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.virtual.PayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return null;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "B2EVirtualAcctTransToEntAcct";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u865a\u8d26\u6237\u5bf9\u5916\u4ed8\u6b3e\u5355\u7b14", (String)"PaymentImpl_10", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !UseConvertor.isSalary((PaymentInfo)paymentInfo) && !UseConvertor.isTransfer((PaymentInfo)paymentInfo) && BankBusinessConfig.isVirtualAccount(paymentInfo.getAccNo());
    }

    public String pack(BankPayRequest request) {
        return PayPacker.packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getURL());
    }
}

