/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.common.framework.handler.AbstractBizHandler;
import kd.ebg.aqap.common.model.BankFile;
import kd.ebg.aqap.common.model.repository.BankFileRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.utils.GetKeyStoreHelper;
import kd.ebg.aqap.proxy.oversea.utils.JDom11Utils;
import kd.ebg.aqap.proxy.oversea.utils.OverseaFileStorageUtil;
import kd.ebg.aqap.proxy.oversea.utils.PgpHelper;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class AbstractOverseaHandler
extends AbstractBizHandler {
    protected final String decryption_prefix = "decryption_";
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractOverseaHandler.class);

    protected void preTask() {
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(this.context.getCustomID()).requestSeqID("").bizName("fileParse").subBizName("fileParse").bankVersionID(this.context.getBankVersionID()).bankLoginID(this.context.getBankLoginID()).bizSeqID(Sequence.gen18Sequence()).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(String.valueOf(System.currentTimeMillis())).loggerBankNo(Sequence.gen18Sequence()).loggerBatchNo(Sequence.gen18Sequence()).loggerDetailNo(Sequence.gen18Sequence()).build();
        EBContext.setContext((EBContext)context);
        EBContext.initParameter();
        MDCUtil.clearBankMDC();
        MDCUtil.initMDC((EBContext)context);
    }

    protected void afterTask() {
        EBContext.destroy();
        this.context = null;
    }

    public File handleDecryFile(File file) throws Exception {
        String needPgp = RequestContextUtils.getBankParameterValue((String)"is_need_pgp");
        File decodeFile = "true".equalsIgnoreCase(needPgp) ? this.decryPgpFile(file) : file;
        return decodeFile;
    }

    protected File decryPgpFile(File file) throws Exception {
        String privateKey = GetKeyStoreHelper.getPgpPrivateKey("custom_pgp_private_key");
        char[] password = RequestContextUtils.getBankParameterValue((String)"custom_pgp_private_key_ciper").toCharArray();
        String newName = file.getName();
        if (newName.contains(".PGP")) {
            newName = newName.replace(".PGP", ".TXT");
        } else if (newName.contains(".pgp")) {
            newName = newName.replace(".pgp", ".txt");
        }
        EBContext context = EBContext.getContext();
        File decodeFile = FileCommonUtils.getFileByPath((String)(OverseaFileStorageUtil.getOriginalFilePath(context.getBankVersionID()) + File.separator + newName));
        PgpHelper pgp = PgpHelper.getInstance();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(decodeFile);){
            pgp.decryptStream(fileInputStream, fileOutputStream, IOUtils.toInputStream((String)privateKey, (String)RequestContextUtils.getCharset()), password);
        }
        this.logger.info("pgp\u89e3\u5bc6\u6210\u529f,\u89e3\u5bc6\u540e\u6587\u4ef6:" + decodeFile.getAbsolutePath());
        return decodeFile;
    }

    protected Element getRootFromFile(File file, String encoding) throws Exception {
        String fileContent = FileUtils.readFileToString((File)file, (String)encoding);
        Document doc = JDom11Utils.str2Doc(fileContent, encoding);
        return doc.getRootElement();
    }

    protected List<SwiftTextBlock> readFileContentAsString(File file) throws Exception {
        StringBuilder buffer = new StringBuilder();
        ArrayList<SwiftTextBlock> list = new ArrayList<SwiftTextBlock>();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("{1:") || line.contains("{2:") || line.contains("{3:") || line.contains("{4:")) continue;
                    if ("-".equals(line) || "-}".equals(line)) {
                        String content = this.packToSwiftTextBlock(buffer.toString().trim());
                        SwiftTextBlock swiftTextBlock = new SwiftTextBlock();
                        swiftTextBlock.setUnParserText(content);
                        swiftTextBlock.parserText();
                        list.add(swiftTextBlock);
                        buffer = new StringBuilder();
                        continue;
                    }
                    buffer.append(line).append("\n");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6\u6587\u4ef6" + file.getName() + "\u53d1\u751f\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        return list;
    }

    protected String packToSwiftTextBlock(String content) {
        return "{4:\n" + content + "\n-}";
    }

    protected void saveFileContentToDB(String fileContent, String fileName, String fileType) {
        BankFile bankFile = new BankFile();
        bankFile.setFileName(fileName);
        bankFile.setFileType(fileType);
        bankFile.setTransDate(LocalDate.now());
        bankFile.setFileContent(fileContent);
        bankFile.setCustomID(EBContext.getContext().getCustomID());
        bankFile.setBankVersionId(EBContext.getContext().getBankVersionID());
        bankFile.setCreateTime(LocalDateTime.now());
        BankFileRepository bankFileRepository = (BankFileRepository)SpringContextUtil.getBean(BankFileRepository.class);
        bankFileRepository.save(bankFile);
    }
}

