/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.repository;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class OverseaBalanceRepository {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaBalanceRepository.class);
    private String OVERSEA_BALANCE_ENTITY = "aqap_oversea_balance";
    private String SELECT_ALL_PROPERTIES = "id,number,name,status,creator,enable,custom_id,bank_name,bank_version,currency,update_source,balance_date,current_balance,available_balance,last_day_balance,frozen_balance,ext_system_field,ext_biz_field,ext_config_field,ext_field1,ext_field2,ext_field3,ext_field4";

    public OverseaBalance getLastestBalance(String accNo, String customId, String currency) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startDate = now.minusDays(7L);
        QFilter filter = QFilter.of((String)"number = ? and custom_id = ? and currency = ?", (Object[])new Object[]{accNo, customId, currency});
        String orderBy = "balance_date desc";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.OVERSEA_BALANCE_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)orderBy);
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            OverseaBalance overseaBalance = this.transferOverseaBalance(dynamicObject);
            return overseaBalance;
        }
        return null;
    }

    public OverseaBalance getLastestBalance(String accNo, String customId, String bankVersion, String currency) {
        return this.getLastestBalance(accNo, customId, currency);
    }

    public OverseaBalance getBalanceByDate(String accNo, String customId, String bankVersion, String currency, LocalDate balanceDate) {
        LocalDateTime end;
        LocalDateTime start = balanceDate.atStartOfDay();
        QFilter filter = QFilter.of((String)"number = ? and custom_id = ? and bank_version = ? and currency = ? and balance_date>= ? and balance_date<=?", (Object[])new Object[]{accNo, customId, bankVersion, currency, start, end = balanceDate.atTime(23, 59, 59)});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.OVERSEA_BALANCE_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            return this.transferOverseaBalance(dynamicObject);
        }
        return null;
    }

    public OverseaBalance transferOverseaBalance(DynamicObject dynamicObject) {
        OverseaBalance overseaBalance = new OverseaBalance();
        overseaBalance.setId(dynamicObject.getLong("id"));
        overseaBalance.setNumber(dynamicObject.getString("number"));
        overseaBalance.setName(dynamicObject.getString("name"));
        overseaBalance.setStatus(dynamicObject.getString("status"));
        overseaBalance.setEnable(dynamicObject.getString("enable"));
        overseaBalance.setCustomId(dynamicObject.getString("custom_id"));
        overseaBalance.setBankName(dynamicObject.getString("bank_name"));
        overseaBalance.setBankVersion(dynamicObject.getString("bank_version"));
        overseaBalance.setCurrency(dynamicObject.getString("currency"));
        overseaBalance.setUpdateSource(dynamicObject.getString("update_source"));
        overseaBalance.setBalanceDate(DTFactoryUtil.parseDateTime((String)dynamicObject.getString("balance_date")));
        overseaBalance.setCurrentBalance(dynamicObject.getBigDecimal("current_balance"));
        overseaBalance.setAvailableBalance(dynamicObject.getBigDecimal("available_balance"));
        overseaBalance.setLastDayBalance(dynamicObject.getBigDecimal("last_day_balance"));
        overseaBalance.setFrozenBalance(dynamicObject.getBigDecimal("frozen_balance"));
        overseaBalance.setExtSystemField(dynamicObject.getString("ext_system_field"));
        overseaBalance.setExtBizField(dynamicObject.getString("ext_biz_field"));
        overseaBalance.setExtConfigField(dynamicObject.getString("ext_config_field"));
        overseaBalance.setExtField1(dynamicObject.getString("ext_field1"));
        overseaBalance.setExtField2(dynamicObject.getString("ext_field2"));
        overseaBalance.setExtField3(dynamicObject.getString("ext_field3"));
        overseaBalance.setExtField4(dynamicObject.getString("ext_field4"));
        return overseaBalance;
    }

    public void updateBalanceMt942(List<OverseaBalance> balanceInfoList) {
        for (OverseaBalance balanceInfo : balanceInfoList) {
            String date = balanceInfo.getBalanceDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String time = LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
            this.updateOrInsertCurBalance(balanceInfo, LocalDateTime.parse(date + time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            this.logger.info("\u66f4\u65b0\u8d26\u53f7" + balanceInfo.getNumber() + "\u7684\u4f59\u989d\u4fe1\u606f\uff1a" + OverseaBalanceRepository.parseBalanceInfo(balanceInfo));
        }
    }

    public void updateBalanceMt940(List<OverseaBalance> balanceInfoList) {
        for (OverseaBalance balanceInfo : balanceInfoList) {
            String date = balanceInfo.getBalanceDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            this.updateOrInsertCurBalance(balanceInfo, LocalDateTime.parse(date + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            this.logger.info("\u66f4\u65b0\u8d26\u53f7" + balanceInfo.getNumber() + "\u7684\u4f59\u989d\u4fe1\u606f\uff1a" + OverseaBalanceRepository.parseBalanceInfo(balanceInfo));
        }
    }

    private void updateOrInsertCurBalance(OverseaBalance balanceInfo, LocalDateTime balanceDateTime) {
        LocalDateTime balanceDate = balanceInfo.getBalanceDate();
        String startStr = balanceDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "000000";
        String endStr = balanceDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "235959";
        LocalDateTime startTime = LocalDateTime.parse(startStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        LocalDateTime endTime = LocalDateTime.parse(endStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        StringBuilder str = new StringBuilder("number=? and currency=? and balance_date>=? and balance_date<=?");
        QFilter filter = QFilter.of((String)str.toString(), (Object[])new Object[]{balanceInfo.getNumber(), balanceInfo.getCurrency(), startTime, endTime});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.OVERSEA_BALANCE_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            balanceInfo.setBalanceDate(balanceDateTime);
            DynamicObject dynamicObject = this.packBalanceInfo(null, balanceInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            balanceInfo.setBalanceDate(balanceDateTime);
            DynamicObject dynamicObject = dynamicObjects[0];
            this.packBalanceInfo(dynamicObject, balanceInfo);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private DynamicObject packBalanceInfo(DynamicObject dynamicObject, OverseaBalance balanceInfo) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.OVERSEA_BALANCE_ENTITY);
        }
        dynamicObject.set("number", (Object)balanceInfo.getNumber());
        dynamicObject.set("name", (Object)balanceInfo.getName());
        String customId = balanceInfo.getCustomId();
        if (StringUtils.isEmpty((String)customId)) {
            customId = EBContext.getContext().getCustomID();
        }
        dynamicObject.set("custom_id", (Object)customId);
        dynamicObject.set("bank_name", (Object)balanceInfo.getBankName());
        dynamicObject.set("bank_version", (Object)balanceInfo.getBankVersion());
        dynamicObject.set("currency", (Object)balanceInfo.getCurrency());
        dynamicObject.set("balance_date", (Object)Date.from(balanceInfo.getBalanceDate().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("current_balance", (Object)balanceInfo.getCurrentBalance());
        dynamicObject.set("available_balance", (Object)balanceInfo.getAvailableBalance());
        dynamicObject.set("last_day_balance", (Object)balanceInfo.getLastDayBalance());
        dynamicObject.set("frozen_balance", (Object)balanceInfo.getFrozenBalance());
        dynamicObject.set("update_source", (Object)balanceInfo.getUpdateSource());
        dynamicObject.set("ext_system_field", (Object)balanceInfo.getExtSystemField());
        dynamicObject.set("ext_biz_field", (Object)balanceInfo.getExtBizField());
        dynamicObject.set("ext_config_field", (Object)balanceInfo.getExtConfigField());
        dynamicObject.set("ext_field1", (Object)balanceInfo.getExtField1());
        dynamicObject.set("ext_field2", (Object)balanceInfo.getExtField2());
        dynamicObject.set("ext_field3", (Object)balanceInfo.getExtField3());
        dynamicObject.set("ext_field4", (Object)balanceInfo.getExtField4());
        return dynamicObject;
    }

    private static String parseBalanceInfo(OverseaBalance balanceInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u8d26\u53f7:", (String)"OverseaBalanceRepository_0", (String)"ebg-aqap-proxy", (Object[])new Object[0])).append(balanceInfo.getNumber()).append(',');
        sb.append(ResManager.loadKDString((String)"\u4f59\u989d:", (String)"OverseaBalanceRepository_1", (String)"ebg-aqap-proxy", (Object[])new Object[0])).append(balanceInfo.getCurrentBalance()).append(',');
        sb.append(ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d:", (String)"OverseaBalanceRepository_2", (String)"ebg-aqap-proxy", (Object[])new Object[0])).append(balanceInfo.getAvailableBalance()).append(',');
        sb.append(ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f:", (String)"OverseaBalanceRepository_3", (String)"ebg-aqap-proxy", (Object[])new Object[0])).append(balanceInfo.getBalanceDate());
        String msg = sb.toString();
        return "[" + msg + "]";
    }
}

