/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.repository;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class OverseaDetailRepository {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaDetailRepository.class);
    private String OVERSEA_Detail_ENTITY = "aqap_oversea_detail";
    private String SELECT_ALL_PROPERTIES = "id,number,name,status,creator,createtime,modifytime,enable,custom_id,pay_bank_name,pay_bank_version,benefit_acc_no,benefit_acc_name,benefit_bank_name,detail_file_name,detail_type,currency,tx_amt,balance,cord_flag,tx_date,detail_no,bank_orderid,trans_type,explanation,use_desc,memory,payid,ext_system_field,ext_biz_field,ext_config_field,ext_field1,ext_field2,ext_field3,ext_field4";

    public List<OverseaDetail> queryDetail(String customId, LocalDate startDate, LocalDate endDate, String accNo, String currency) {
        String end = endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endStr = end + "235959";
        QFilter filter = QFilter.of((String)"custom_id = ? and number = ? and currency = ? and tx_date >= ? and tx_date <= ?", (Object[])new Object[]{customId, accNo, currency, startDate, LocalDateTime.parse(endStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"))});
        String orderBy = "tx_Date asc, createtime asc";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.OVERSEA_Detail_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)orderBy);
        if (dynamicObjects != null) {
            ArrayList<OverseaDetail> detailInfos = new ArrayList<OverseaDetail>(16);
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                OverseaDetail overseaDetail = this.transferOverseaDetail((DynamicObject)dynamicObjects.get(i));
                detailInfos.add(overseaDetail);
            }
            return detailInfos;
        }
        return Lists.newArrayList();
    }

    public void updateDetailFromMT942(List<OverseaDetail> detailInfoList) {
        if (CollectionUtil.isEmpty(detailInfoList)) {
            return;
        }
        String fileName = detailInfoList.get(0).getDetailFileName();
        String customId = detailInfoList.get(0).getCustomId();
        this.deleteDetails(fileName, customId);
        this.insertDetail(detailInfoList);
    }

    public void updateDetailFromMT940(List<OverseaDetail> detailInfoList) {
        if (CollectionUtil.isEmpty(detailInfoList)) {
            return;
        }
        this.deleteDetails(detailInfoList);
        this.insertDetail(detailInfoList);
    }

    private void insertDetail(List<OverseaDetail> detailList) {
        if (CollectionUtil.isEmpty(detailList)) {
            return;
        }
        for (int i = 0; i < detailList.size(); ++i) {
            DynamicObject dynamicObject = this.packOverseaDetailInfo(null, detailList.get(i));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.logger.info("\u63d2\u5165\u660e\u7ec6\uff1a" + this.parseDetailGen(detailList.get(i)));
        }
        this.logger.info("\u6210\u529f\u63d2\u5165" + detailList.size() + "\u7b14\u660e\u7ec6.");
    }

    private DynamicObject packOverseaDetailInfo(DynamicObject dynamicObject, OverseaDetail overseaDetail) {
        Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.OVERSEA_Detail_ENTITY);
            dynamicObject.set("createtime", (Object)now);
        }
        dynamicObject.set("number", (Object)overseaDetail.getNumber());
        dynamicObject.set("name", (Object)overseaDetail.getName());
        String customId = overseaDetail.getCustomId();
        if (StringUtils.isEmpty((String)customId)) {
            customId = EBContext.getContext().getCustomID();
        }
        dynamicObject.set("custom_id", (Object)customId);
        dynamicObject.set("pay_bank_name", (Object)overseaDetail.getPayBankName());
        dynamicObject.set("pay_bank_version", (Object)overseaDetail.getPayBankVersion());
        dynamicObject.set("benefit_acc_no", (Object)overseaDetail.getBenefitAccNo());
        dynamicObject.set("benefit_acc_name", (Object)overseaDetail.getBenefitAccName());
        dynamicObject.set("benefit_bank_name", (Object)overseaDetail.getBenefitBankName());
        dynamicObject.set("detail_file_name", (Object)overseaDetail.getDetailFileName());
        dynamicObject.set("detail_type", (Object)overseaDetail.getDetailType());
        dynamicObject.set("currency", (Object)overseaDetail.getCurrency());
        dynamicObject.set("tx_amt", (Object)overseaDetail.getTxAmt());
        dynamicObject.set("balance", (Object)overseaDetail.getBalance());
        dynamicObject.set("cord_flag", (Object)overseaDetail.getCordFlag());
        dynamicObject.set("tx_date", (Object)Date.from(overseaDetail.getTxDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("detail_no", (Object)overseaDetail.getDetail_no());
        dynamicObject.set("bank_orderid", (Object)overseaDetail.getBankOrderid());
        dynamicObject.set("trans_type", (Object)overseaDetail.getTransType());
        dynamicObject.set("explanation", (Object)overseaDetail.getExplanation());
        dynamicObject.set("use_desc", (Object)overseaDetail.getUseDesc());
        dynamicObject.set("memory", (Object)overseaDetail.getMemory());
        dynamicObject.set("payid", (Object)overseaDetail.getPayid());
        dynamicObject.set("ext_system_field", (Object)overseaDetail.getExtSystemField());
        dynamicObject.set("ext_biz_field", (Object)overseaDetail.getExtBizField());
        dynamicObject.set("ext_config_field", (Object)overseaDetail.getExtConfigField());
        dynamicObject.set("ext_field1", (Object)overseaDetail.getExtField1());
        dynamicObject.set("ext_field2", (Object)overseaDetail.getExtField2());
        dynamicObject.set("ext_field3", (Object)overseaDetail.getExtField3());
        dynamicObject.set("ext_field4", (Object)overseaDetail.getExtField4());
        dynamicObject.set("modifytime", (Object)now);
        return dynamicObject;
    }

    public OverseaDetail transferOverseaDetail(DynamicObject dynamicObject) {
        OverseaDetail overseaDetail = new OverseaDetail();
        overseaDetail.setId(dynamicObject.getLong("id"));
        overseaDetail.setNumber(dynamicObject.getString("number"));
        overseaDetail.setName(dynamicObject.getString("name"));
        overseaDetail.setStatus(dynamicObject.getString("status"));
        overseaDetail.setCreatetime(DTFactoryUtil.parseDateTime((String)dynamicObject.getString("createtime")));
        overseaDetail.setModifytime(DTFactoryUtil.parseDateTime((String)dynamicObject.getString("modifytime")));
        overseaDetail.setEnable(dynamicObject.getString("enable"));
        overseaDetail.setCustomId(dynamicObject.getString("custom_id"));
        overseaDetail.setPayBankName(dynamicObject.getString("pay_bank_name"));
        overseaDetail.setPayBankVersion(dynamicObject.getString("pay_bank_version"));
        overseaDetail.setBenefitAccNo(dynamicObject.getString("benefit_acc_no"));
        overseaDetail.setBenefitAccName(dynamicObject.getString("benefit_acc_name"));
        overseaDetail.setBenefitBankName(dynamicObject.getString("benefit_bank_name"));
        overseaDetail.setDetailFileName(dynamicObject.getString("detail_file_name"));
        overseaDetail.setDetailType(dynamicObject.getString("detail_type"));
        overseaDetail.setCurrency(dynamicObject.getString("currency"));
        overseaDetail.setTxAmt(dynamicObject.getBigDecimal("tx_amt"));
        overseaDetail.setBalance(dynamicObject.getBigDecimal("balance"));
        overseaDetail.setCordFlag(dynamicObject.getString("cord_flag"));
        overseaDetail.setTxDate(DTFactoryUtil.parseDate((String)dynamicObject.getString("tx_date")));
        overseaDetail.setDetail_no(dynamicObject.getString("detail_no"));
        overseaDetail.setBankOrderid(dynamicObject.getString("bank_orderid"));
        overseaDetail.setTransType(dynamicObject.getString("trans_type"));
        overseaDetail.setExplanation(dynamicObject.getString("explanation"));
        overseaDetail.setUseDesc(dynamicObject.getString("use_desc"));
        overseaDetail.setMemory(dynamicObject.getString("memory"));
        overseaDetail.setPayid(dynamicObject.getString("payid"));
        overseaDetail.setExtSystemField(dynamicObject.getString("ext_system_field"));
        overseaDetail.setExtBizField(dynamicObject.getString("ext_biz_field"));
        overseaDetail.setExtConfigField(dynamicObject.getString("ext_config_field"));
        overseaDetail.setExtField1(dynamicObject.getString("ext_field1"));
        overseaDetail.setExtField2(dynamicObject.getString("ext_field2"));
        overseaDetail.setExtField3(dynamicObject.getString("ext_field3"));
        overseaDetail.setExtField4(dynamicObject.getString("ext_field4"));
        return overseaDetail;
    }

    private void deleteDetails(String fileName, String customId) {
        QFilter filter = QFilter.of((String)"custom_id = ? and detail_file_name = ?", (Object[])new Object[]{customId, fileName});
        int delete = DeleteServiceHelper.delete((String)this.OVERSEA_Detail_ENTITY, (QFilter[])filter.toArray());
        this.logger.info("\u5220\u9664\u6587\u4ef6\u540d\u4e3a[" + fileName + "]\u7684\u660e\u7ec6\u4fe1\u606f\u6709[" + delete + "]\u6761.");
    }

    private void deleteDetails(List<OverseaDetail> detailInfoList) {
        if (CollectionUtil.isEmpty(detailInfoList)) {
            return;
        }
        LocalDate startDate = this.getStartDate(detailInfoList);
        LocalDate endDate = this.getEndDate(detailInfoList);
        String startStr = startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "000000";
        String endStr = endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "235959";
        LocalDateTime startTime = LocalDateTime.parse(startStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        LocalDateTime endTime = LocalDateTime.parse(endStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String customId = detailInfoList.get(0).getCustomId();
        HashSet<String> set = new HashSet<String>(16);
        for (OverseaDetail info : detailInfoList) {
            String accNo = info.getNumber();
            set.add(accNo + "_" + info.getCurrency());
        }
        for (String accNoAndCurrency : set) {
            String[] s = accNoAndCurrency.split("_");
            String accNo = s[0];
            String currency = s[1];
            QFilter filter = QFilter.of((String)"custom_id = ? and number = ? and currency = ? and tx_date>=? and tx_date<=?", (Object[])new Object[]{customId, accNo, currency, startTime, endTime});
            int delete = DeleteServiceHelper.delete((String)this.OVERSEA_Detail_ENTITY, (QFilter[])filter.toArray());
            this.logger.info("\u5220\u9664\u5e10\u53f7:" + accNo + "\uff0c\u5e01\u522b:" + currency + "\uff0c\u65e5\u671f[" + startStr + " - " + endStr + "]\u65f6\u95f4\u5185\u7684\u660e\u7ec6\u4fe1\u606f\u6709[" + delete + "]\u6761");
        }
    }

    private LocalDate getStartDate(List<OverseaDetail> detailInfoList) {
        LocalDate txDate = detailInfoList.get(0).getTxDate();
        for (int i = 1; i < detailInfoList.size(); ++i) {
            if (!txDate.isAfter(detailInfoList.get(i).getTxDate())) continue;
            txDate = detailInfoList.get(i).getTxDate();
        }
        return txDate;
    }

    private LocalDate getEndDate(List<OverseaDetail> detailInfoList) {
        LocalDate txDate = detailInfoList.get(0).getTxDate();
        for (int i = 1; i < detailInfoList.size(); ++i) {
            if (!txDate.isBefore(detailInfoList.get(i).getTxDate())) continue;
            txDate = detailInfoList.get(i).getTxDate();
        }
        return txDate;
    }

    private String parseDetailGen(OverseaDetail detail) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("AccNo:").append(detail.getNumber()).append(", ");
        sb.append("BenefitAccNo:").append(detail.getBenefitAccNo()).append(", ");
        sb.append("TxAmt:").append(detail.getTxAmt()).append(", ");
        sb.append("Currency:").append(detail.getCurrency()).append(", ");
        sb.append("CordFlag:").append(detail.getCordFlag()).append(", ");
        sb.append("TxDate:").append(detail.getTxDate());
        sb.append("]");
        return sb.toString();
    }
}

