/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.utils;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.proxy.oversea.CompratorByLastModified;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class OverseaFileStorageUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaFileStorageUtil.class);

    public static String getOverseaPayFilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "pay", bankVersionID);
    }

    public static String getMT940FilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "mt940", bankVersionID);
    }

    public static String getMT942FilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "mt942", bankVersionID);
    }

    public static String getXmlAckFilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "xmlack", bankVersionID);
    }

    public static String getMT940BakFilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "mt940_bak", bankVersionID);
    }

    public static String getMT942BakFilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "mt942_bak", bankVersionID);
    }

    public static String getXmlAckBakFilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "xmlack_bak", bankVersionID);
    }

    public static String getDownloadFileTempPath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "temp", bankVersionID);
    }

    public static String getOriginalFilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "original", bankVersionID);
    }

    public static String getOverseaIgnoreFilePath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "ignore", bankVersionID);
    }

    public static String getOverseaAttachmentPath(String bankVersionID) {
        return OverseaFileStorageUtil.getPath(OverseaFileStorageUtil.getStorageRootPath(), "attachment", bankVersionID);
    }

    public static String getStorageRootPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        String storageRootPath = System.getProperty("user.dir");
        OverseaFileStorageUtil.checkAndCreatePath(storageRootPath + File.separator + "oversea" + File.separator + customID);
        return storageRootPath + File.separator + "oversea" + File.separator + customID;
    }

    private static String getPath(String rootPath, String path, String bankVersionID) {
        StringBuilder sb = new StringBuilder();
        sb.append(rootPath).append(File.separator).append(bankVersionID).append(File.separator).append(path);
        String fixedPath = sb.toString();
        OverseaFileStorageUtil.checkAndCreatePath(fixedPath);
        return fixedPath;
    }

    private static void checkAndCreatePath(String path) {
        File file = FileCommonUtils.getFileByPath((String)path);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8def\u5f84: %s\u53d1\u751f\u5f02\u5e38\u3002", (String)"OverseaFileStorageUtil_2", (String)"ebg-aqap-proxy", (Object[])new Object[0]), path), (Throwable)e);
            }
        }
    }

    public static boolean cutFile(File file, String destPath) {
        if (!file.exists()) {
            return true;
        }
        File destDir = FileCommonUtils.getFileByPath((String)destPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File destFile = FileCommonUtils.getFileByPath((String)destPath, (String)file.getName());
        int index = 1;
        while (destFile.exists()) {
            destFile = FileCommonUtils.getFileByPath((String)destPath, (String)(file.getName() + "-" + index));
            ++index;
        }
        return file.renameTo(destFile);
    }

    public static List<File> scanFiles(File dir) {
        LinkedList<File> list = new LinkedList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!OverseaFileStorageUtil.isFileCompleted(file)) {
                    logger.info("\u6587\u4ef6'" + file.getAbsolutePath() + "'\u672a\u63a5\u6536\u5b8c\u6210\uff0c\u7b49\u5f85\u4e0b\u6b21\u5904\u7406");
                    continue;
                }
                list.add(file);
            }
            list.sort(CompratorByLastModified.File_LastModified_Asc_Comprator);
        }
        return list;
    }

    private static boolean isFileCompleted(File file) {
        return file.renameTo(file);
    }
}

