/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import kd.ebg.aqap.proxy.swift.utils.SwiftStringUtils;

public class SwiftFormatUtils {
    private static final transient Logger log = Logger.getLogger(SwiftFormatUtils.class.getName());

    public static Calendar getDate2(String strDate) {
        if (strDate != null && strDate.length() == 6) {
            return SwiftFormatUtils.getCalendar(strDate, "yyMMdd");
        }
        return null;
    }

    public static Calendar getDate1(String strDate) {
        if (strDate != null && strDate.length() == 4) {
            return SwiftFormatUtils.getCalendar(strDate, "MMdd");
        }
        return null;
    }

    public static String getDate2(Calendar date) {
        if (date != null) {
            return new SimpleDateFormat("yyMMdd").format(date.getTime());
        }
        return null;
    }

    public static Calendar getDate3(String strDate) {
        if (strDate != null && strDate.length() == 4) {
            return SwiftFormatUtils.getCalendar(strDate, "yyMM");
        }
        return null;
    }

    public static Calendar getDate4(String strDate) {
        if (strDate != null && strDate.length() == 8) {
            return SwiftFormatUtils.getCalendar(strDate, "yyyyMMdd");
        }
        return null;
    }

    public static BigDecimal getBigDecimal(String amount) {
        BigDecimal bigDecimal = null;
        if (amount != null) {
            Number number = SwiftFormatUtils.getNumber(amount);
            if (number != null) {
                bigDecimal = new BigDecimal(number.toString());
            } else {
                log.log(Level.WARNING, "Error parsing BigDecimal, " + amount);
            }
        }
        return bigDecimal;
    }

    public static Number getNumber(String amount) {
        Number number = null;
        if (amount != null) {
            try {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setDecimalSeparator(',');
                DecimalFormat df = new DecimalFormat("00.##", symbols);
                number = df.parse(amount);
            }
            catch (ParseException e) {
                log.log(Level.WARNING, "Error parsing number", e);
            }
        }
        return number;
    }

    public static Calendar getHhmm(String hhmm) {
        if (hhmm != null && hhmm.length() == 4) {
            return SwiftFormatUtils.getCalendar(hhmm, "HHmm");
        }
        return null;
    }

    private static Calendar getCalendar(String value, String format) {
        if (value != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setLenient(false);
                Date d = sdf.parse(value);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(d);
                return cal;
            }
            catch (ParseException e) {
                log.log(Level.INFO, "Caught exception in SwiftFormatUtils, method getCalendar", e);
            }
        }
        return null;
    }

    public static Calendar getTime2(String hhmmss) {
        if (hhmmss != null && hhmmss.length() == 6) {
            return SwiftFormatUtils.getCalendar(hhmmss, "HHmmss");
        }
        return null;
    }

    public static Character getSign(String string) {
        if (SwiftStringUtils.isNotEmpty(string)) {
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }

    public static Calendar getOffset(String string) {
        Calendar result = SwiftFormatUtils.getHhmm(string);
        return result;
    }

    public static void main(String[] args) {
        SwiftFormatUtils.getDate2("151204");
    }
}

