/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.ca.bean;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import sun.security.x509.X509Key;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public CertAndKeyGen(String paramString1, String paramString2) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(paramString1);
        this.sigAlg = paramString2;
    }

    public void setRandom(SecureRandom paramSecureRandom) {
        this.prng = paramSecureRandom;
    }

    public void generate(int paramInt) {
        KeyPair localKeyPair;
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(paramInt, this.prng);
            localKeyPair = this.keyGen.generateKeyPair();
        }
        catch (Exception localException) {
            throw new IllegalArgumentException(localException.getMessage(), localException);
        }
        this.publicKey = localKeyPair.getPublic();
        this.privateKey = localKeyPair.getPrivate();
        if (!"X.509".equalsIgnoreCase(this.publicKey.getFormat())) {
            throw new IllegalArgumentException("publicKey's is not X.509, but " + this.publicKey.getFormat());
        }
    }

    public X509Key getPublicKey() {
        if (!(this.publicKey instanceof X509Key)) {
            return null;
        }
        return (X509Key)this.publicKey;
    }

    public PublicKey getPublicKeyAnyway() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getSelfCertificate(X500Name paramX500Name, Date paramDate, long paramLong) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(paramX500Name, paramDate, paramLong, null);
    }

    public X509Certificate getSelfCertificate(X500Name paramX500Name, Date paramDate, long paramLong, CertificateExtensions paramCertificateExtensions) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Date localDate = new Date();
            localDate.setTime(paramDate.getTime() + paramLong * 1000L);
            CertificateValidity localCertificateValidity = new CertificateValidity(paramDate, localDate);
            X509CertInfo localX509CertInfo = new X509CertInfo();
            localX509CertInfo.set("version", new CertificateVersion(2));
            localX509CertInfo.set("serialNumber", new CertificateSerialNumber(new SecureRandom().nextInt() & Integer.MAX_VALUE));
            AlgorithmId localAlgorithmId = AlgorithmId.get(this.sigAlg);
            localX509CertInfo.set("algorithmID", new CertificateAlgorithmId(localAlgorithmId));
            localX509CertInfo.set("subject", paramX500Name);
            localX509CertInfo.set("key", new CertificateX509Key(this.publicKey));
            localX509CertInfo.set("validity", localCertificateValidity);
            localX509CertInfo.set("issuer", paramX500Name);
            if (paramCertificateExtensions != null) {
                localX509CertInfo.set("extensions", paramCertificateExtensions);
            }
            X509CertImpl localX509CertImpl = new X509CertImpl(localX509CertInfo);
            localX509CertImpl.sign(this.privateKey, this.sigAlg);
            return localX509CertImpl;
        }
        catch (IOException localIOException) {
            throw new CertificateEncodingException("getSelfCert: " + localIOException.getMessage(), localIOException);
        }
    }
}

