/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.ca.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class PKCSToJKS {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PKCSToJKS.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void JSKToPKCS12(String srcFile, String srcPasswd, String destFile, String destPasswd) {
        FileInputStream fis = null;
        FileOutputStream out = null;
        try {
            KeyStore inputKeyStore = KeyStore.getInstance("JKS");
            fis = new FileInputStream(FileCommonUtils.checkPath((String)srcFile));
            char[] srcPwd = null;
            char[] destPwd = null;
            srcPwd = srcPasswd == null || srcPasswd.trim().equals("") ? null : srcPasswd.toCharArray();
            destPwd = destPasswd == null || destPasswd.trim().equals("") ? null : destPasswd.toCharArray();
            inputKeyStore.load(fis, srcPwd);
            fis.close();
            KeyStore outputKeyStore = KeyStore.getInstance("PKCS12");
            Enumeration<String> enums = inputKeyStore.aliases();
            while (enums.hasMoreElements()) {
                String keyAlias = enums.nextElement();
                System.out.println("alias=[" + keyAlias + "]");
                outputKeyStore.load(null, destPwd);
                if (inputKeyStore.isKeyEntry(keyAlias)) {
                    Key key = inputKeyStore.getKey(keyAlias, srcPwd);
                    Certificate[] certChain = inputKeyStore.getCertificateChain(keyAlias);
                    outputKeyStore.setKeyEntry(keyAlias, key, destPwd, certChain);
                }
                String fName = destFile;
                out = new FileOutputStream(FileCommonUtils.checkPath((String)fName));
                outputKeyStore.store(out, destPwd);
                outputKeyStore.deleteEntry(keyAlias);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        PKCSToJKS c = new PKCSToJKS();
        c.JSKToPKCS12("E:\\code\\proxy\\1\\CurrentTest.keystore", "789", "E:\\code\\proxy\\1\\openapi-cert.p12", "789");
    }
}

