/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.bankversion;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.StringUtil;

public class BanklistListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_KEY_BANK_LIST = "aqap_bank_list";
    private static final String ENTITY_KEY_BANK = "aqap_bank";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private static final String selectColumn = "id, number,name,bank_name,bank_type,mature,biz_type,sort_num,type,note,note_status";

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        List qFilters = ((BillList)args.getSource()).getQueryFilterParameter().getQFilters();
        qFilters.add(QFilter.of((String)"status=? and enable=?", (Object[])new Object[]{"C", "0"}));
        final DynamicObjectCollection dataCollection = this.getCollection(qFilters);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return dataCollection.size();
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dObjectCollection = this.getStartToEnd(start, limit, dataCollection);
                int dataCount = dataCollection.size();
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                return dObjectCollection;
            }

            private DynamicObjectCollection getStartToEnd(int start, int limit, DynamicObjectCollection dCollection) {
                DynamicObjectCollection data = QueryServiceHelper.query((String)BanklistListPlugin.ENTITY_KEY_BANK_LIST, (String)BanklistListPlugin.selectColumn, null);
                int end = start + limit;
                int size = dCollection.size();
                if (size >= end) {
                    for (int i = start; i < end; ++i) {
                        DynamicObject dynamicObject = (DynamicObject)dCollection.get(i);
                        data.add((Object)dynamicObject);
                    }
                } else {
                    for (int i = start; i < size; ++i) {
                        DynamicObject dynamicObject = (DynamicObject)dCollection.get(i);
                        data.add((Object)dynamicObject);
                    }
                }
                return data;
            }
        });
    }

    private DynamicObjectCollection getCollection(List<QFilter> qFilters) {
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY_BANK_LIST, (String)selectColumn, null);
        List<BankVersionInfo> bankVersionList = this.infoService.getBankVersionInfoList();
        Collections.sort(bankVersionList);
        Map<String, DynamicObject> disableBankVersionMap = this.getDisableBankVersionMap(qFilters);
        bankVersionList.stream().forEach(bankVersionInfo -> {
            boolean isShowData = false;
            if (disableBankVersionMap.get(bankVersionInfo.getBankVersionID()) != null) {
                isShowData = true;
            }
            if (isShowData) {
                DynamicObject data = dCollection.addNew();
                String bankVersionId = bankVersionInfo.getBankVersionID();
                DynamicObject dynamicObject = this.getBankInfoByBankVersion(bankVersionId);
                if (dynamicObject != null) {
                    String note;
                    OrmLocaleValue channelType;
                    String localeValue;
                    String bizType;
                    String bankType = (String)dynamicObject.get("bank_type");
                    if (!StringUtil.isNullOrEmpty(bankType)) {
                        data.set("bank_type", (Object)dynamicObject.getString("bank_type"));
                    }
                    if (!StringUtil.isNullOrEmpty(bizType = (String)dynamicObject.get("biz_type"))) {
                        data.set("biz_type", (Object)dynamicObject.getString("biz_type"));
                    }
                    if (!StringUtil.isNullOrEmpty(localeValue = (channelType = (OrmLocaleValue)dynamicObject.get("type")).getLocaleValue())) {
                        data.set("type", (Object)localeValue);
                    }
                    if (!StringUtil.isNullOrEmpty(note = dynamicObject.getString("note"))) {
                        data.set("note", (Object)note);
                    }
                }
                data.set("id", (Object)bankVersionInfo.getBankVersionID().hashCode());
                data.set("number", (Object)bankVersionInfo.getBankVersionID());
                data.set("name", dynamicObject.get("name"));
                data.set("bank_name", dynamicObject.get("bank_name"));
                data.set("sort_num", (Object)bankVersionInfo.getSortNum());
                String note_status = dynamicObject.getString("note_status");
                data.set("note_status", (Object)note_status);
            }
        });
        return dCollection;
    }

    DynamicObjectCollection getAvailableBankVersionDatas() {
        QFilter qFilter = QFilter.of((String)"status=? and enable=?", (Object[])new Object[]{"C", "1"});
        return QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable,note_status", (QFilter[])qFilter.toArray());
    }

    DynamicObjectCollection getDisableBankVersionDatas(List<QFilter> qFilters) {
        return QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable,note_status", (QFilter[])qFilters.toArray(new QFilter[16]));
    }

    Map<String, DynamicObject> getAvailableBankVersionMap() {
        DynamicObjectCollection bankVersionDatas = this.getAvailableBankVersionDatas();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        bankVersionDatas.stream().forEach(bankVersionData -> map.put((String)bankVersionData.get("number"), (DynamicObject)bankVersionData));
        return map;
    }

    Map<String, DynamicObject> getDisableBankVersionMap(List<QFilter> qFilters) {
        DynamicObjectCollection bankVersionDatas = this.getDisableBankVersionDatas(qFilters);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        bankVersionDatas.stream().forEach(bankVersionData -> map.put((String)bankVersionData.get("number"), (DynamicObject)bankVersionData));
        return map;
    }

    DynamicObject getBankInfoByBankVersion(String bankVersion) {
        QFilter qFilter = QFilter.of((String)"status=? and enable=? and number=?", (Object[])new Object[]{"C", "0", bankVersion});
        DynamicObject domainObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable,bank_type,mature,biz_type,type,note,note_status", (QFilter[])qFilter.toArray());
        return domainObject;
    }
}

