/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.baseplugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public enum CompareEnum {
    YESTERDAY("11"),
    TODAY("13"),
    THISMONTH("63"),
    THISWEEK("10");

    String id;

    public String getId() {
        return this.id;
    }

    private CompareEnum(String id) {
        this.id = id;
    }

    public static CompareEnum getCompareEnumByID(String id) {
        for (CompareEnum item : CompareEnum.values()) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public String getStartDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = new Date();
        if (this == THISWEEK) {
            time = this.getThisWeekStart();
        } else if (this == THISMONTH) {
            time = this.getThisMonthStart();
        } else if (this == YESTERDAY) {
            time = this.getLastDay();
        } else if (this == TODAY) {
            time = this.getCurrentDay();
        }
        String timeFormat = sdf.format(time);
        return timeFormat;
    }

    public String getEndDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = new Date();
        if (this == THISWEEK) {
            time = this.getThisWeekEnd();
        } else if (this == THISMONTH) {
            time = this.getThisMonthEnd();
        } else if (this == TODAY) {
            time = this.getNextDay();
        } else if (this == YESTERDAY) {
            time = this.getCurrentDay();
        }
        String timeFormat = sdf.format(time);
        return timeFormat;
    }

    private Date getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getNextDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getThisWeekStart() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    private Date getThisWeekEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getThisWeekStart());
        cal.add(7, 7);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    private Date getThisMonthStart() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, Calendar.getInstance().getActualMinimum(5));
        return cal.getTime();
    }

    private Date getThisMonthEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, Calendar.getInstance().getActualMaximum(5));
        cal.add(5, 1);
        return cal.getTime();
    }
}

