/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OtherCertAlertSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String selectProperties = "cert_type, bank_config_name, file_name, expire_time, remark, mobiles, is_alert, alert_day, alert_type, custom_id, type, cert_source";
    private String EB_SAVE = "eb_OtherCertAlertSettingPlugin_isSave";
    private String BANK_LOGIN = "bank_config_name_b";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bankLoginFieldEdit = (BasedataEdit)this.getView().getControl(this.BANK_LOGIN);
        if (bankLoginFieldEdit != null) {
            bankLoginFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)this.BANK_LOGIN)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
        }
    }

    public void beforeBindData(EventObject e) {
        Long id;
        DynamicObject dynamicObject;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String type = (String)paramMap.get("type");
        if ("update".equalsIgnoreCase(type) && (dynamicObject = QueryServiceHelper.queryOne((String)"aqap_bd_cert", (String)selectProperties, (QFilter[])new QFilter("id", "=", (Object)(id = (Long)paramMap.get("id"))).toArray())) != null) {
            String certType = dynamicObject.getString("cert_type");
            this.getModel().setValue("cert_type", (Object)certType);
            if (CertTypeEnum.BANKLOGIN.getType().equals(Integer.parseInt(certType))) {
                String bankLoginId = dynamicObject.getString("bank_config_name");
                DynamicObject bankLogin = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_login", (String)"id, number, name", (QFilter[])QFilter.of((String)"number = ?", (Object[])new Object[]{bankLoginId}).toArray());
                this.getModel().setValue(this.BANK_LOGIN, (Object)bankLogin);
            } else {
                this.getModel().setValue("bank_config_name", (Object)dynamicObject.getString("bank_config_name"));
            }
            this.getModel().setValue("file_name", (Object)dynamicObject.getString("file_name"));
            this.getModel().setValue("expire_time", (Object)dynamicObject.getDate("expire_time"));
            this.getModel().setValue("remark", (Object)dynamicObject.getString("remark"));
            this.getModel().setValue("mobiles", (Object)dynamicObject.getString("mobiles"));
            this.getModel().setValue("alert_day", (Object)dynamicObject.getLong("alert_day"));
            this.getModel().setValue("alert_type", (Object)dynamicObject.getString("alert_type"));
            this.getModel().setValue("is_alert", (Object)dynamicObject.getBoolean("is_alert"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)"save", (String)operateKey)) {
            String mobiles = (String)this.getModel().getValue("mobiles");
            boolean isAlert = (Boolean)this.getModel().getValue("is_alert");
            if (isAlert && StringUtils.isEmpty((String)mobiles)) {
                this.getView().showTipNotification(MultiLang.getMobileNotEmptyTip());
                args.setCancel(true);
            } else {
                String[] res = mobiles.split("\\;");
                HashMap<String, Integer> checkRepeatMap = new HashMap<String, Integer>(16);
                for (int i = 0; i < res.length; ++i) {
                    String mobile = res[i];
                    if (StringUtils.isEmpty((String)mobile)) continue;
                    if (!StringUtils.isChinaPhoneLegal((String)mobile)) {
                        this.getView().showTipNotification(MultiLang.getPhoneNumberFormatTip(i + 1));
                        args.setCancel(true);
                        return;
                    }
                    if (checkRepeatMap.get(mobile) != null) {
                        int beforeIndex = (Integer)checkRepeatMap.get(mobile) + 1;
                        this.getView().showTipNotification(MultiLang.getPhoneNumberRepeatTip(beforeIndex, i + 1));
                        args.setCancel(true);
                        return;
                    }
                    checkRepeatMap.put(mobile, i);
                }
                this.doSave();
            }
        }
    }

    public void doSave() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String type = (String)paramMap.get("type");
        if ("add".equalsIgnoreCase(type)) {
            this.add();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8bc1\u4e66\u8fc7\u671f\u9884\u8b66\u65b0\u589e\u6210\u529f\u3002", (String)"OtherCertAlertSettingPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(this.EB_SAVE, "true");
            this.getView().invokeOperation("close");
        } else if ("update".equalsIgnoreCase(type)) {
            Long id = (Long)paramMap.get("id");
            this.update(id);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8bc1\u4e66\u8fc7\u671f\u9884\u8b66\u4fee\u6539\u6210\u529f\u3002", (String)"OtherCertAlertSettingPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(this.EB_SAVE, "true");
            this.getView().invokeOperation("close");
        }
    }

    public void add() {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"aqap_bd_cert");
        this.save(dataEntity);
    }

    public void update(Long id) {
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((String)"aqap_bd_cert", (String)selectProperties, (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        this.save(dataEntity);
    }

    public void save(DynamicObject dataEntity) {
        String certType = (String)this.getModel().getValue("cert_type");
        String bankConfigName = (String)this.getModel().getValue("bank_config_name");
        String fileName = (String)this.getModel().getValue("file_name");
        Date expireTime = (Date)this.getModel().getValue("expire_time");
        String mobiles = (String)this.getModel().getValue("mobiles");
        int alertDay = (Integer)this.getModel().getValue("alert_day");
        String alertType = (String)this.getModel().getValue("alert_type");
        boolean isAlert = (Boolean)this.getModel().getValue("is_alert");
        String remark = (String)this.getModel().getValue("remark");
        String customID = RequestContext.get().getTenantId();
        if (CertTypeEnum.BANKLOGIN.getType().equals(Integer.parseInt(certType))) {
            bankConfigName = this.getModel().getDataEntity().getString("bank_config_name_b.number");
        }
        dataEntity.set("cert_type", (Object)certType);
        dataEntity.set("bank_config_name", (Object)bankConfigName);
        dataEntity.set("file_name", (Object)fileName);
        dataEntity.set("expire_time", (Object)expireTime);
        dataEntity.set("mobiles", (Object)mobiles);
        dataEntity.set("alert_day", (Object)alertDay);
        dataEntity.set("alert_type", (Object)alertType);
        dataEntity.set("is_alert", (Object)isAlert);
        dataEntity.set("remark", (Object)remark);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("type", (Object)CertType.OTHER_CER.getType());
        dataEntity.set("cert_source", (Object)CertSource.OTHER.getSource());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if ("true".equalsIgnoreCase(this.getPageCache().get(this.EB_SAVE))) {
            this.getView().returnDataToParent((Object)true);
        }
    }
}

