/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.common;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;

public class EbcAddBankListPlugin
extends AbstractTreeListPlugin {
    private static final String ENTITY_KEY_BANK = "aqap_bank";
    private static final String ENTITY_KEY_BANK_LIST = "aqap_bank_list";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.initTreeListModel();
    }

    public void initTreeListModel() {
        TreeListModel model = (TreeListModel)this.getTreeListView().getTreeModel();
        model.getQueryParas().put("order", "sort_num asc, number asc");
    }

    private void refreshTreeView() {
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        if (tree != null) {
            ListView listView = (ListView)tree.getView();
            listView.refresh();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"add_bank", (CharSequence)formOperate.getOperateKey())) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)ENTITY_KEY_BANK_LIST, (boolean)true, (int)0, (boolean)true);
            StyleCss style = new StyleCss();
            style.setWidth("1000");
            style.setHeight("600");
            listShowParameter.getOpenStyle().setInlineStyleCss(style);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u542f\u7528", (String)"EbcAddBankListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        if (StringUtils.equals((CharSequence)"new", (CharSequence)formOperate.getOperateKey())) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNode = treeView.getTreeState().getFocusNode();
            String text = (String)focusNode.get("text");
            if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"BankAcntListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equals(text)) {
                this.getView().showTipNotification(MultiLang.getSelectBankTip());
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        TreeNode rootNode = null;
        try {
            rootNode = ((TreeListView)((ListView)tree.getView()).getTreeListView()).getRoot();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            Map<String, DynamicObject> map = this.getAvailableBankVersionMap();
            Map<String, String> bankNameMap = this.getBankNameMap();
            for (ListSelectedRow row : selectCollections) {
                String number = row.getNumber();
                String name = row.getName();
                String bankName = bankNameMap.get(number);
                DynamicObject bankVersionData = map.get(number);
                if (bankVersionData == null || "1".equals(bankVersionData.get("enable")) && "C".equals(bankVersionData.get("status"))) continue;
                this.update(bankVersionData, number, name, bankName);
                if (rootNode == null) continue;
                rootNode.addChild(new TreeNode(rootNode.getId(), bankVersionData.getString("id"), name));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"EbcAddBankListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            if (rootNode != null) {
                tree.updateNode(rootNode);
            }
            this.refreshTreeView();
            this.getView().invokeOperation("refresh");
        }
    }

    DynamicObject[] getBankVersionDatas() {
        QFilter filter = QFilter.of((String)"id > ?", (Object[])new Object[]{0});
        return BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable", (QFilter[])filter.toArray());
    }

    Map<String, DynamicObject> getAvailableBankVersionMap() {
        DynamicObject[] bankVersionDatas = this.getBankVersionDatas();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (bankVersionDatas != null && bankVersionDatas.length > 0) {
            for (DynamicObject bankVersionData : bankVersionDatas) {
                map.put((String)bankVersionData.get("number"), bankVersionData);
            }
        }
        return map;
    }

    Map<String, String> getBankNameMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        List<BankVersionInfo> bankVersionInfos = this.infoService.getBankVersionInfoList();
        bankVersionInfos.stream().forEach(bankVersionInfo -> map.put(bankVersionInfo.getBankVersionID(), bankVersionInfo.getBankName()));
        return map;
    }

    void save(String number, String name, String bankName) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_BANK);
        dataEntity.set("status", (Object)"C");
        dataEntity.set("enable", (Object)"1");
        dataEntity.set("number", (Object)number);
        dataEntity.set("name", (Object)name);
        dataEntity.set("bank_name", (Object)bankName);
        SaveServiceHelper.saveOperate((String)ENTITY_KEY_BANK, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
    }

    void update(DynamicObject bankVersionData, String number, String name, String bankName) {
        bankVersionData.set("number", (Object)number);
        bankVersionData.set("status", (Object)"C");
        bankVersionData.set("enable", (Object)"1");
        SaveServiceHelper.save((IDataEntityType)bankVersionData.getDataEntityType(), (Object[])new DynamicObject[]{bankVersionData});
    }
}

