/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.index;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.aqap.formplugin.pojo.AcntCountInfo;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;

public class BankAndAcntStatisticsPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private BankVersionRepository bankVersionRepository = (BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class);
    private BankAcntRepository bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
    private int bank_version_count = 0;
    private int bank_acnt_count = 0;
    private int receipt_acnt_count = 0;
    private int note_acnt_count = 0;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (StringUtils.equals((CharSequence)"bank_version_name", (CharSequence)evt.getFieldName())) {
            ShowPageUtil.showListPage("aqap_bank", this.getView());
        } else if (StringUtils.equals((CharSequence)"acnt_num", (CharSequence)evt.getFieldName())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("bank_version_id", this.getPageCache().get("rowindex_" + evt.getRowIndex()));
            ShowPageUtil.showListPage("aqap_bank_acnt", "aqap_bos_templatetree", customParams, this.getView());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.showData();
    }

    private void showData() {
        this.loadData();
        Label label4 = (Label)this.getControl("bank_version_count");
        label4.setText(this.bank_version_count + "");
        Label label5 = (Label)this.getControl("bank_acnt_count");
        label5.setText(this.bank_acnt_count + "");
        Label label6 = (Label)this.getControl("receipt_acnt_count");
        label6.setText(this.receipt_acnt_count + "");
        Label label7 = (Label)this.getControl("note_acnt_count");
        label7.setText(this.note_acnt_count + "");
    }

    private void loadData() {
        DynamicObject[] bankversions = this.bankVersionRepository.loadEnableDynamicObjects();
        this.bank_version_count = bankversions == null || bankversions.length == 0 ? 0 : bankversions.length;
        this.bank_acnt_count = this.bankAcntRepository.countAcnt();
        this.receipt_acnt_count = this.bankAcntRepository.countReceiptAcnt();
        this.note_acnt_count = this.bankAcntRepository.countNoteAcnt();
        this.buildEntryRow(bankversions);
    }

    public void buildEntryRow(DynamicObject[] dynamicObjects) {
        Map<Long, AcntCountInfo> acntStats = this.countReceiptAcntGroupByBankVersions();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                int row = this.getModel().createNewEntryRow("entryentity");
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", row);
                dynamicObject.set("bank_version_name", (Object)dynamicObjects[i].getString("name"));
                dynamicObject.set("bank_version_id", (Object)dynamicObjects[i].getString("number"));
                AcntCountInfo ac = acntStats.get(dynamicObjects[i].getLong("id"));
                if (ac == null) {
                    dynamicObject.set("acnt_num", (Object)0);
                    dynamicObject.set("receipt_acnt_num", (Object)0);
                    dynamicObject.set("note_acnt_num", (Object)0);
                } else {
                    dynamicObject.set("acnt_num", (Object)ac.getAcntCount());
                    dynamicObject.set("receipt_acnt_num", (Object)ac.getReceiptAcntCount());
                    dynamicObject.set("note_acnt_num", (Object)ac.getNoteAcntCount());
                }
                this.getPageCache().put("rowindex_" + row, dynamicObjects[i].getString("id"));
            }
        }
    }

    public Map<Long, AcntCountInfo> countReceiptAcntGroupByBankVersions() {
        String algoKey = "countReceiptAcntGroupByBankVersions";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aqap_bank_acnt", (String)"number,group,custom_id,has_receipt,has_note", (QFilter[])new QFilter[]{QFilter.of((String)"enable='1'", (Object[])new Object[0])}, (String)"group");
        DataSet acntDs = dataSet.groupBy(new String[]{"group"}).count("count").finish();
        DataSet receiptAcntDs = dataSet.filter("has_receipt= '1'").groupBy(new String[]{"group"}).count("count").finish();
        DataSet noteAcntDs = dataSet.filter("has_note= '1'").groupBy(new String[]{"group"}).count("count").finish();
        Iterator iterator = acntDs.iterator();
        HashMap<Long, AcntCountInfo> result = new HashMap<Long, AcntCountInfo>(16);
        while (iterator.hasNext()) {
            AcntCountInfo acntCountInfo;
            Row row = (Row)iterator.next();
            Long groupID = row.getLong("group");
            if (result.get(groupID) != null) {
                acntCountInfo = (AcntCountInfo)result.get(groupID);
            } else {
                acntCountInfo = new AcntCountInfo();
                result.put(groupID, acntCountInfo);
            }
            acntCountInfo.setAcntCount(row.getInteger("count"));
        }
        for (Row row : receiptAcntDs) {
            AcntCountInfo acntCountInfo;
            Long groupID = row.getLong("group");
            if (result.get(groupID) != null) {
                acntCountInfo = (AcntCountInfo)result.get(groupID);
            } else {
                acntCountInfo = new AcntCountInfo();
                result.put(groupID, acntCountInfo);
            }
            acntCountInfo.setReceiptAcntCount(row.getInteger("count"));
        }
        for (Row row : noteAcntDs) {
            AcntCountInfo acntCountInfo;
            Long groupID = row.getLong("group");
            if (result.get(groupID) != null) {
                acntCountInfo = (AcntCountInfo)result.get(groupID);
            } else {
                acntCountInfo = new AcntCountInfo();
                result.put(groupID, acntCountInfo);
            }
            acntCountInfo.setNoteAcntCount(row.getInteger("count"));
        }
        return result;
    }
}

