/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.utils.log.OperationLogUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LinkMonitorSetting
extends AbstractFormPlugin {
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String objectID = "common_business";
        String objectName = "monitor_setting";
        String selectFields = "attr_key, attr_value";
        QFilter filter = QFilter.of((String)"object_id=?  and object_name=?", (Object[])new Object[]{objectID, objectName});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)selectFields, (QFilter[])filter.toArray());
        HashMap<String, String> mm = new HashMap<String, String>(16);
        for (DynamicObject d : dynamicObjects) {
            mm.put(d.getString("attr_key"), d.getString("attr_value"));
        }
        this.getModel().setValue("alert_type", (Object)ResManager.loadKDString((String)"\u624b\u673a\u77ed\u4fe1", (String)"SJDX_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("phone_number", mm.get("phone_number"));
        this.getModel().setValue("notice_rate", mm.get("notice_rate"));
        this.getModel().setValue("monitor_rate", mm.get("monitor_rate"));
        this.getModel().setValue("monitor_type", mm.get("monitor_type"));
        this.getModel().setValue("history_time", mm.get("history_time"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.save(args);
    }

    void delete() {
        QFilter[] qFilters = new QFilter[]{new QFilter("object_id", "=", (Object)"common_business"), new QFilter("object_name", "=", (Object)"monitor_setting")};
        DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])qFilters);
    }

    void save(BeforeDoOperationEventArgs args) {
        String objectId = "common_business";
        String objectName = "monitor_setting";
        String alertType = this.getModel().getValue("alert_type").toString();
        String email = "";
        String phoneNumber = "";
        phoneNumber = this.getModel().getValue("phone_number").toString();
        if (StringUtils.isNotEmpty((String)phoneNumber)) {
            String[] res = phoneNumber.split("\\;");
            for (int i = 0; i < res.length; ++i) {
                if (LinkMonitorSetting.isChinaPhoneLegal(res[i])) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u624b\u673a\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u5f55\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u3002", (String)"LinkMonitorSetting_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), i + 1));
                args.setCancel(true);
                return;
            }
        }
        email = "";
        String noticeRate = this.getModel().getValue("notice_rate").toString();
        if (StringUtil.isNil(noticeRate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u901a\u77e5\u9891\u7387\u3002", (String)"LinkMonitorSetting_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String monitorRate = this.getModel().getValue("monitor_rate").toString();
        if (StringUtil.isNil(monitorRate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u76d1\u63a7\u9891\u7387\u3002", (String)"LinkMonitorSetting_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String historyTime = this.getModel().getValue("history_time").toString();
        if (StringUtil.isNil(historyTime)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5386\u53f2\u8bb0\u5f55\u5b58\u50a8\u5468\u671f\u3002", (String)"LinkMonitorSetting_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.delete();
        String customID = RequestContext.get().getTenantId();
        DynamicObject dataEntity1 = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity1.set("attr_key", (Object)"alert_type");
        dataEntity1.set("attr_value", (Object)alertType);
        dataEntity1.set("object_id", (Object)objectId);
        dataEntity1.set("object_name", (Object)objectName);
        dataEntity1.set("custom_id", (Object)customID);
        DynamicObject dataEntity2 = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity2.set("attr_key", (Object)"email");
        dataEntity2.set("attr_value", (Object)email);
        dataEntity2.set("object_id", (Object)objectId);
        dataEntity2.set("object_name", (Object)objectName);
        dataEntity2.set("custom_id", (Object)customID);
        DynamicObject dataEntity3 = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity3.set("attr_key", (Object)"phone_number");
        dataEntity3.set("attr_value", (Object)phoneNumber);
        dataEntity3.set("object_id", (Object)objectId);
        dataEntity3.set("object_name", (Object)objectName);
        dataEntity3.set("custom_id", (Object)customID);
        DynamicObject dataEntity4 = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity4.set("attr_key", (Object)"notice_rate");
        dataEntity4.set("attr_value", (Object)noticeRate);
        dataEntity4.set("object_id", (Object)objectId);
        dataEntity4.set("object_name", (Object)objectName);
        dataEntity4.set("custom_id", (Object)customID);
        DynamicObject dataEntity5 = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity5.set("attr_key", (Object)"monitor_rate");
        dataEntity5.set("attr_value", (Object)monitorRate);
        dataEntity5.set("object_id", (Object)objectId);
        dataEntity5.set("object_name", (Object)objectName);
        dataEntity5.set("custom_id", (Object)customID);
        DynamicObject dataEntity7 = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity7.set("attr_key", (Object)"history_time");
        dataEntity7.set("attr_value", (Object)historyTime);
        dataEntity7.set("object_id", (Object)objectId);
        dataEntity7.set("object_name", (Object)objectName);
        dataEntity7.set("custom_id", (Object)customID);
        DynamicObject[] dataEntities = new DynamicObject[]{dataEntity1, dataEntity2, dataEntity3, dataEntity4, dataEntity5, dataEntity7};
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "LinkMonitorSetting_8", "ebg-aqap-formplugin");
        MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u524d\u7f6e\u673a\u76d1\u63a7\u53c2\u6570\u914d\u7f6e\u4fdd\u5b58\u6210\u529f\u3002", "LinkMonitorSetting_7", "ebg-aqap-formplugin");
        OperationLogUtil.recordInvoke((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[0]);
    }

    public static boolean isChinaPhoneLegal(String str) throws PatternSyntaxException {
        String regExp = "^((13[0-9])|(14[5,7,9])|(15[0-3,5-9])|(166)|(17[3,5,6,7,8])|(18[0-9])|(19[1,8,9]))\\d{8}$";
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

