/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hlbrcb.cmp.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hlbrcb.cmp.utils.DetailFileProxy;
import kd.ebg.aqap.banks.hlbrcb.cmp.utils.EncodingUtil;
import kd.ebg.aqap.banks.hlbrcb.cmp.utils.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.BytesReaderHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element root = Packer.createRoot("100003");
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"Currency", (String)bankDetailRequest.getBankCurrency());
        LocalDate startDate = bankDetailRequest.getStartDate();
        LocalDate endDate = bankDetailRequest.getEndDate();
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("Head");
        String respCode = head.getChildTextTrim("RspCode");
        String respInfo = head.getChildTextTrim("RspMsg");
        if (!"000000".equalsIgnoreCase(respCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]), respCode, respInfo));
        }
        Element body = root.getChild("Body");
        String fileName = body.getChildTextTrim("FileName");
        DetailFileProxy detailFileProxy = new DetailFileProxy();
        String fileContent = "";
        try {
            fileContent = detailFileProxy.getContent(fileName);
        }
        catch (Exception e) {
            this.logger.error("\u4ece\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(1);
        String[] lines = null;
        try {
            lines = StringUtils.split2Lines((String)fileContent);
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u51fa\u9519\uff0c\u8bfb\u53d6\u884c\u5931\u8d25\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        if (lines == null || lines.length < 1) {
            return new EBBankDetailResponse(details);
        }
        DetailInfo detail = new DetailInfo();
        detail.setAccNo(acnt.getAccNo());
        detail.setAccName(acnt.getAccName());
        detail.setBankName(acnt.getBankName());
        for (String line : lines) {
            String encoding = RequestContextUtils.getCharset();
            byte[] recieveBytes = EncodingUtil.encode(line, encoding);
            BytesReaderHelper reader = new BytesReaderHelper(recieveBytes, encoding);
            reader.read(2);
            String isLastRecord = reader.read(1);
            String date = reader.read(10);
            String transNo = reader.read(8);
            String subTransNo = reader.read(6);
            try {
                LocalDate txDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyyMMdd"));
                detail.setTransDate(txDate);
                detail.setTransTime(LocalDateTime.parse(date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                this.logger.error("\u89e3\u6790\u4ea4\u6613\u65e5\u671f\u5931\u8d25", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u4ea4\u6613\u65e5\u671f\u5931\u8d25\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]), (Throwable)e);
            }
            String currency = reader.read(3);
            detail.setCurrency(currency);
            reader.read(1);
            String amountStr = reader.read(15);
            String isCreditStr = reader.read(1);
            if ("C".equals(isCreditStr)) {
                detail.setCreditAmount(BigDecimalHelper.div((String)amountStr, (String)"100"));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("D".equals(isCreditStr)) {
                detail.setDebitAmount(BigDecimalHelper.div((String)amountStr, (String)"100"));
                detail.setCreditAmount(new BigDecimal("0.00"));
            }
            String balanceStr = reader.read(15);
            if (!StringUtils.isEmpty((String)balanceStr)) {
                detail.setBalance(BigDecimalHelper.div((String)balanceStr, (String)"100"));
            }
            reader.read(1);
            reader.read(5);
            reader.read(40);
            reader.read(5);
            reader.read(40);
            reader.read(1);
            reader.read(3);
            reader.read(32);
            reader.read(6);
            reader.read(6);
            reader.read(6);
            String oppAcntNumber = reader.read(22);
            detail.setOppAccNo(oppAcntNumber);
            reader.read(6);
            String oppAcntName = reader.read(62);
            detail.setOppAccName(oppAcntName);
            reader.read(2);
            reader.read(3);
            String explanation = reader.read(42);
            detail.setExplanation(explanation);
            reader.read(1);
            reader.read(256);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transDate", (Object)date);
            jsonObject.put("dcFlag", (Object)isCreditStr);
            jsonObject.put("amount", (Object)amountStr);
            jsonObject.put("transNo", (Object)transNo);
            jsonObject.put("subTransNo", (Object)subTransNo);
            detail.setJsonMap(jsonObject.toString());
            detail.setBankDetailNo(transNo);
            details.add(detail);
        }
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "100003";
    }

    public String getBizDesc() {
        return null;
    }
}

