/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.sign;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.util.EncodingUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SignService
extends AbstractImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SignService.class);

    public static String sign(Element opReq) throws EBServiceException {
        logger.info("---------\u7b7e\u540d\u5f00\u59cb----------");
        if (!BankBusinessConfig.isSig()) {
            return "null";
        }
        SignService signService = new SignService();
        String originData = signService.createSignReqMsg(opReq);
        String sidnedContent = signService.dosign(originData);
        String signedData = signService.getSignedData(sidnedContent);
        logger.info("---------\u7b7e\u540d\u5b8c\u6210----------");
        return signedData;
    }

    public static String sign(String opReq) throws EBServiceException {
        logger.info("---------\u7b7e\u540d\u5f00\u59cb----------");
        SignService signService = new SignService();
        String originData = signService.createSignReqMsg(opReq);
        String sidnedContent = signService.dosign(originData);
        String signedData = signService.getSignedData(sidnedContent);
        logger.info("---------\u7b7e\u540d\u5b8c\u6210----------");
        return signedData;
    }

    private String dosign(String signMsg) throws EBServiceException {
        String sidnedContent = null;
        try {
            logger.info("\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587:\n" + signMsg);
            sidnedContent = this.sendAndRcv4Sign(signMsg);
            logger.infoFilerLog("\u7b7e\u540d\u8fd4\u56de\u62a5\u6587:" + sidnedContent);
            return sidnedContent.trim();
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u670d\u52a1\u5668\u7b7e\u540d\u5931\u8d25\uff0c\u539f\u56e0:%1$s\u3002", (String)"SignService_6", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), ex.getMessage()), (Throwable)ex);
        }
    }

    private String createSignReqMsg(Element opReq) throws EBServiceException {
        String originData = DomHelper.element2StringPlain(opReq, "gbk");
        return this.createSignReqMsg(originData);
    }

    private String createSignReqMsg(String originData) throws EBServiceException {
        String requestMsg = "<?xml version=\"1.0\" encoding=\"gbk\" ?>\n<msg>\n<msg_head>\n<msg_type>0</msg_type>\n<msg_id>1005</msg_id>\n<msg_sn>0</msg_sn>\n<version>1</version>\n</msg_head>\n<msg_body>\n<origin_data_len>" + EncodingUtil.encode(originData, "gbk").length + "</origin_data_len>\n<origin_data>" + originData + "</origin_data>\n</msg_body>\n</msg>";
        return requestMsg;
    }

    private String getSignedData(String sidnedContent) throws EBServiceException {
        Element msg;
        Element msgBody;
        String errorNo;
        logger.info("\u51c6\u5907\u89e3\u6790\u8fd4\u56de\u7684\u8282\u70b9<signed_data>\u6570\u636e.");
        if (!sidnedContent.startsWith("<?xml")) {
            String add = "<?xml version=\"1.0\" encoding=\"gb2312\"?><msg>";
            logger.info("\u8fd4\u56de\u6570\u636e\u672a\u5305\u542b<?xml \u5934\u6307\u4ee4,\u94f6\u4f01\u8865\u5145\u6570\u636e:" + add);
            sidnedContent = add + sidnedContent;
        }
        if (null != (errorNo = DomHelper.getChildText(msgBody = DomHelper.getChildElementNotNull(msg = JDomUtils.string2Root((String)sidnedContent, (String)"GBK"), "msg_body"), "error_no"))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25, \u7b7e\u540d\u8fd4\u56de\u9519\u8bef\u53f7<error_no>:%1$s", (String)"SignService_7", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), errorNo));
        }
        String signedData = DomHelper.getChildTextNotNull(msgBody, "signed_data");
        if (signedData != null) {
            return signedData;
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25,\u8fd4\u56de\u6570\u636e\u4e2d\u8282\u70b9<signed_data>\u4e0d\u5b58\u5728", (String)"SignService_2", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
    }

    /*
     * Exception decompiling
     */
    private String sendAndRcv4Sign(String signMsg) throws EBServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

