/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdcb.cms.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdcb.cms.utils.Packer;
import kd.ebg.aqap.banks.cdcb.cms.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element ap = Packer.creatHead("03020101A0008", Sequence.gen18Sequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)bankBalanceRequest.getBankCurrency());
        String request = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Packer.createCommonMsg(request);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element element = Parser.getResponseElement(rspStr);
        Parser.resSuccessCheck(element);
        Element body = element.getChild("body");
        Element dto = body.getChild("dto");
        String bookBal = dto.getChildText("bookBal");
        String avaliableBal = dto.getChildText("avaliableBal");
        String frzBal = dto.getChildText("frzBal");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        BigDecimal zero = new BigDecimal("0.00");
        balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)bookBal, (Boolean)false));
        if (StringUtils.isNotEmpty((String)avaliableBal)) {
            balanceInfo.setAvailableBalance(new BigDecimal(avaliableBal));
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>();
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020101A0008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]);
    }
}

