/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.payment.allocation;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.SCNXDCMetaDataImpl;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonPacker;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonParser;
import kd.ebg.aqap.banks.scnx.dc.services.utils.ScnxConstants;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationQueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = CommonPacker.packHeader(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"PG_NO", (String)"1");
        JDomUtils.addChild((Element)body, (String)"PG_SIZE", (String)"50");
        JDomUtils.addChild((Element)body, (String)"GRPPRNTCORPCUSTNO", (String)RequestContextUtils.getBankParameterValue((String)SCNXDCMetaDataImpl.custom_no));
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NM", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NO", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"APRPTAMTBGN", (String)"");
        JDomUtils.addChild((Element)body, (String)"APRPTAMTEND", (String)"");
        String dateStr = LocalDateUtil.formatDate((LocalDateTime)paymentInfo.getSubmitSuccessTime());
        JDomUtils.addChild((Element)body, (String)"TXTMBGN", (String)dateStr);
        JDomUtils.addChild((Element)body, (String)"TXTMEND", (String)dateStr);
        JDomUtils.addChild((Element)body, (String)"TXSTUSCD", (String)"A");
        JDomUtils.addChild((Element)body, (String)"APRPTTYPCD", (String)ScnxConstants.ALLOCATION_CODE_MAP.get(paymentInfo.getUseCn()));
        JDomUtils.addChild((Element)body, (String)"BIZFLOW", (String)paymentInfo.getBankDetailSeqId());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse response = CommonParser.parserHead(root);
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element body = root.getChild("BODY");
            Element loop = body.getChild("LOOP");
            List details = loop.getChildren("DETAIL");
            if (details != null && details.size() == 1) {
                Element detail = (Element)details.get(0);
                String stats = detail.getChildText("TXSTUSCD");
                String msg = detail.getChildText("MSG");
                if ("S".equals(stats)) {
                    EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.SUCCESS, (String)"", (String)stats, (String)msg);
                } else if ("P".equals(stats)) {
                    EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)stats, (String)msg);
                } else if ("F".equals(stats)) {
                    EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.FAIL, (String)"", (String)stats, (String)msg);
                } else {
                    EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)stats, (String)msg);
                }
            } else {
                EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a\u6216\u8005\u4e0d\u552f\u4e00\u3002", (String)"AllocationQueryPaymentImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]));
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "TC012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5212\u62e8\u7ed3\u679c", (String)"AllocationQueryPaymentImpl_1", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]);
    }
}

