/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.h2h.services.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field13D;
import kd.ebg.aqap.proxy.swift.model.field.Field20;
import kd.ebg.aqap.proxy.swift.model.field.Field21;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field28C;
import kd.ebg.aqap.proxy.swift.model.field.Field34F;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.model.field.Field86;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BNPP_H2H_MT942_Handler
extends AbstractMT942Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BNPP_H2H_MT942_Handler.class);

    protected List<SwiftTextBlock> readFileContentAsString(File file) throws Exception {
        StringBuilder buffer = new StringBuilder();
        ArrayList<SwiftTextBlock> list = new ArrayList<SwiftTextBlock>();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("{1:") || line.contains("{2:") || line.contains("{3:") || line.contains("{4:")) continue;
                    if ("-}".equals(line) || "-}{5:}".equals(line) || line.contains("\u0003")) {
                        String content = this.packToSwiftTextBlock(buffer.toString().trim());
                        SwiftTextBlock swiftTextBlock = new SwiftTextBlock();
                        swiftTextBlock.setUnParserText(content);
                        swiftTextBlock.parserText();
                        list.add(swiftTextBlock);
                        buffer = new StringBuilder();
                        continue;
                    }
                    buffer.append(line).append("\n");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6\u6587\u4ef6" + file.getName() + "\u53d1\u751f\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        return list;
    }

    protected void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            List<SwiftTextBlock> list = this.readFileContentAsString(file);
            for (SwiftTextBlock aList : list) {
                this.parseCurrDetails(aList, name, detailInfoList, payInfoList, balanceInfoList);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s", (String)"BNPP_H2H_MT942_Handler_0", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), name, e.getMessage()), (Throwable)e);
            return;
        }
    }

    private void parseCurrDetails(SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        Field20 field20 = new Field20(swiftTextBlock.getTagValue("20"));
        Field21 field21 = new Field21(swiftTextBlock.getTagValue("21"));
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        this.logger.info("Field25:" + field25.toString());
        Field28C field28C = new Field28C(swiftTextBlock.getTagValue("28C"));
        Field34F field34F = new Field34F(swiftTextBlock.getTagValue("34F"));
        Field13D field13D = new Field13D(swiftTextBlock.getTagValue("13D"));
        String acntNumber = field25.getComponent1();
        String currency = field34F.getComponent1();
        if (acntNumber.contains(currency)) {
            acntNumber = acntNumber.substring(0, acntNumber.lastIndexOf("-"));
        }
        this.parse61To86Tags(swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList);
    }

    private void parse61To86Tags(SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailList, List<PaymentInfo> payInfoList) {
        List tags = swiftTextBlock.getTags();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return;
        }
        for (int aTag61Index : tag61Index) {
            String time;
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            String onlyId = field61.toString().replaceAll(", ", "");
            onlyId = onlyId.substring(1, onlyId.length() - 1);
            String today = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            if (!today.equals(time = today.substring(0, 4) + field61.getComponent2())) {
                this.logger.info(ResManager.loadKDString((String)"\u8be5\u7b14\u660e\u7ec6\u4ea4\u6613\u65e5\u671f\u4e0d\u662f\u4eca\u5929\uff0c\u4e0d\u8fdb\u884c\u89e3\u6790", (String)"BNPP_H2H_MT942_Handler_1", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
                continue;
            }
            OverseaDetail detail = new OverseaDetail();
            detail.setTxDate(LocalDate.parse(time, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setDetail_no(onlyId);
            detail.setNumber(acntNumber);
            detail.setPayBankName("BNPP");
            detail.setPayBankVersion(this.context.getBankVersionID());
            detail.setDetailFileName(fileName);
            detail.setCreatetime(LocalDateTime.now());
            detail.setCustomId(EBContext.getContext().getCustomID());
            detail.setCurrency(currency);
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit) || "EC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit) || "ED".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else if ("RC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else if ("RD".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411.", (String)"BNPP_H2H_MT940_Handler_2", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), creditOrDebit));
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim().toLowerCase();
            detail.setExtField1(custRef);
            this.logger.info("Field61:" + field61.toString());
            String transType = field61.getComponent6();
            detail.setTransType(transType);
            Tag tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)aTag61Index, (int)(aTag61Index + 1));
            if (null != tag86) {
                Field86 field86 = new Field86(tag86.getTagValue());
                this.logger.info("Field86:" + field86.toString());
                StringBuilder str = new StringBuilder();
                List field86List = field86.getComponents();
                for (String fie : field86List) {
                    if (StringUtils.isEmpty((String)fie) || "null".equals(fie)) continue;
                    str.append(fie);
                }
                detail.setExplanation(str.toString());
                this.parseField86Payment(str.toString(), detail);
                if ("NONREF".equalsIgnoreCase(detail.getBenefitAccName())) {
                    detail.setBenefitAccName("");
                }
            }
            try {
                PaymentInfo paymentInfo = OverseaDBHelper.getPaymentInfoByBankDetailSeqId((String)custRef);
                if (paymentInfo != null) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BNPP_H2H_MT940_Handler_3", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)"PAY_SUCCESS", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BNPP_H2H_MT940_Handler_3", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
                    payInfoList.add(paymentInfo);
                }
            }
            catch (Exception e) {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u4ed8\u6b3e\u6570\u636e\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u4ed8\u6b3e\u72b6\u6001%1$s", (String)"BNPP_H2H_MT940_Handler_4", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), e));
            }
            detailList.add(detail);
        }
    }

    private void parseField86Payment(String tag86, OverseaDetail detail) {
        String value3;
        String substring3;
        String value2;
        String substring2;
        String value1;
        String substring1;
        if (tag86.contains("/BENM/")) {
            this.logger.info("BENM:");
            substring1 = tag86.substring(tag86.indexOf("/BENM/") + 6);
            this.logger.info("substring1:" + substring1);
            value1 = substring1.substring(0, substring1.indexOf("/"));
            this.logger.info("value1:" + value1);
            detail.setBenefitAccNo(value1);
            substring2 = substring1.substring(substring1.indexOf("/") + 1);
            this.logger.info("substring2:" + substring2);
            value2 = substring2.substring(0, substring2.indexOf("/"));
            this.logger.info("value2:" + value2);
            detail.setBenefitBankName(value2);
            substring3 = substring2.substring(substring2.indexOf("/") + 1);
            this.logger.info("substring2:" + substring3);
            value3 = substring3.substring(0, substring3.indexOf("/"));
            this.logger.info("value2:" + value3);
            detail.setBenefitAccName(value3);
        }
        if (tag86.contains("/ORDP/")) {
            this.logger.info("ORDP:");
            substring1 = tag86.substring(tag86.indexOf("/ORDP/") + 6);
            this.logger.info("substring1:" + substring1);
            value1 = substring1.substring(0, substring1.indexOf("/"));
            this.logger.info("value1:" + value1);
            detail.setBenefitAccNo(value1);
            substring2 = substring1.substring(substring1.indexOf("/") + 1);
            this.logger.info("substring2:" + substring2);
            value2 = substring2.substring(0, substring2.indexOf("/"));
            this.logger.info("value2:" + value2);
            detail.setBenefitBankName(value2);
            substring3 = substring2.substring(substring2.indexOf("/") + 1);
            this.logger.info("substring2:" + substring3);
            value3 = substring3.substring(0, substring3.indexOf("/"));
            this.logger.info("value2:" + value3);
            detail.setBenefitAccName(value3);
        }
        if (tag86.contains("/REMI/")) {
            this.logger.info("REMI:");
            substring1 = tag86.substring(tag86.indexOf("/REMI/") + 6);
            this.logger.info("substring1:" + substring1);
            value1 = "";
            value1 = substring1.indexOf("/") == -1 ? substring1 : substring1.substring(0, substring1.indexOf("/"));
            this.logger.info("value1:" + value1);
            detail.setExplanation(value1);
        }
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return fileName.contains("MT942");
    }
}

