/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.h2h.services.payment;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bnpp.h2h.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.bnpp.h2h.util.TH2HPacker;
import kd.ebg.aqap.banks.bnpp.h2h.util.TH2HParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u7b14\u4ed8\u6b3e\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
        }
        Element simulator = new Element("simulator");
        Element head = TH2HPacker.createHead("BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)"1");
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)paymentInfo.getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"acntNo", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)list, (String)"acntName", (String)((PaymentInfo)paymentInfos.get(i)).getAccName());
            JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
            JDomUtils.addChild((Element)list, (String)"acntBankName", (String)((PaymentInfo)paymentInfos.get(i)).getBankName());
            JDomUtils.addChild((Element)list, (String)"acntBankCountry", (String)((PaymentInfo)paymentInfos.get(i)).getAccCountry());
            JDomUtils.addChild((Element)list, (String)"acntProvince", (String)((PaymentInfo)paymentInfos.get(i)).getAccProvince());
            JDomUtils.addChild((Element)list, (String)"acntCity", (String)((PaymentInfo)paymentInfos.get(i)).getAccCity());
            JDomUtils.addChild((Element)list, (String)"acntBankBranchNo", (String)((PaymentInfo)paymentInfos.get(i)).getAreaCode());
            JDomUtils.addChild((Element)list, (String)"acntBankCnapsNo", (String)"");
            JDomUtils.addChild((Element)list, (String)"currency", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            Date now = new Date();
            JDomUtils.addChild((Element)list, (String)"startDate", (String)DateTimeUtils.format((Date)now, (String)"yyyyMMdd"));
            JDomUtils.addChild((Element)list, (String)"startTime", (String)DateTimeUtils.format((Date)now, (String)"HHmmss"));
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId());
            JDomUtils.addChild((Element)list, (String)"txAmt", (String)BigDecimalHelper.plain2((BigDecimal)((PaymentInfo)paymentInfos.get(i)).getAmount()));
            JDomUtils.addChild((Element)list, (String)"urgentFlag", (String)(((PaymentInfo)paymentInfos.get(i)).is2Urgent() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameBankFlag", (String)(((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameCityFlag", (String)(((PaymentInfo)paymentInfos.get(i)).is2SameCity() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"payType", (String)(((PaymentInfo)paymentInfos.get(i)).is2Individual() ? "individual" : "company"));
            JDomUtils.addChild((Element)list, (String)"email", (String)((PaymentInfo)paymentInfos.get(i)).getEmails());
            if (PaymentImpl.isContainsStrangeStr(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u8d26\u53f7\uff0c\u4e0d\u80fd\u542b\u6709\u975e\u6cd5\u5b57\u7b26\uff1a ~ ! @ # $ % ^ & * _ { } \" ` = [ ] \u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)list, (String)"oppAcntNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            String oppAcntName = ((PaymentInfo)paymentInfos.get(i)).getIncomeAccName();
            if (!PaymentImpl.isENStr(oppAcntName)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u8d26\u6237\u540d\u79f0\u3010%1$s\u3011\u5fc5\u987b\u4e3a\u82f1\u6587\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), oppAcntName));
            }
            JDomUtils.addChild((Element)list, (String)"oppAcntName", (String)oppAcntName);
            JDomUtils.addChild((Element)list, (String)"oppAcntNameEN", (String)"");
            String oppBankName = ((PaymentInfo)paymentInfos.get(i)).getIncomeBankName();
            if (!PaymentImpl.isENStr(oppBankName)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c\u540d\u79f0\u3010%1$s\u3011\u5fc5\u987b\u4e3a\u82f1\u6587\u3002", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), oppBankName));
            }
            JDomUtils.addChild((Element)list, (String)"oppBankName", (String)oppBankName);
            JDomUtils.addChild((Element)list, (String)"oppAcntProvince", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeProvince());
            JDomUtils.addChild((Element)list, (String)"oppAcntCity", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCity());
            JDomUtils.addChild((Element)list, (String)"oppBankCnapsNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            String swiftcode = ((PaymentInfo)paymentInfos.get(i)).getIncomeSwiftCode();
            if (StringUtils.isEmpty((String)swiftcode)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884cSWIFT Code\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)list, (String)"oppBankBranchNo", (String)swiftcode);
            JDomUtils.addChild((Element)list, (String)"useCode", (String)"");
            JDomUtils.addChild((Element)list, (String)"payUseCode", (String)((PaymentInfo)paymentInfos.get(i)).getUseCode());
            String oppAcntCountry = ((PaymentInfo)paymentInfos.get(i)).getIncomeCountry();
            if (StringUtils.isEmpty((String)oppAcntCountry)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)list, (String)"payeeCountry", (String)oppAcntCountry);
            JDomUtils.addChild((Element)list, (String)"oppAcntCountry", (String)oppAcntCountry);
            String explanation = ((PaymentInfo)paymentInfos.get(i)).getExplanation();
            if (StringUtils.isEmpty((String)((PaymentInfo)paymentInfos.get(i)).getExplanation())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
            }
            if (!PaymentImpl.isENStr(explanation)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6458\u8981 %2$s \u5fc5\u987b\u4e3a\u82f1\u6587\u3002", (String)"PaymentImpl_9", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), explanation));
            }
            JDomUtils.addChild((Element)list, (String)"explanation", (String)explanation);
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    private static boolean isENStr(String w) {
        String regex = "^[A-Za-z0-9-_( )]+$";
        Pattern pattern = Pattern.compile(regex, 2);
        return pattern.matcher(w).matches();
    }

    private static boolean isContainsStrangeStr(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return false;
        }
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (ch != '~' && ch != '!' && ch != '@' && ch != '#' && ch != '$' && ch != '%' && ch != '^' && ch != '&' && ch != '*' && ch != '_' && ch != '{' && ch != '}' && ch != '\"' && ch != '`' && ch != '=' && ch != '[' && ch != ']' && ch != ';') continue;
            return true;
        }
        return false;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = TH2HParser.parseHeader(root);
        if ("BIZ_FAIL".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_10", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        if (!"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_11", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (lists == null || lists.size() < 1) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u5217\u8868\u4e3a\u7a7a\u3002", (String)"PaymentImpl_12", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        Element list = (Element)lists.get(0);
        String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
        Element status = JDomUtils.getChildElement((Element)list, (String)"status");
        String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
        String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if ("BCC_PAY_SUBMT_SUCCESS".equals(txStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_13", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_14", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u652f\u4ed8\u91d1\u989d\u8d85\u51fa\u4eba\u6c11\u5e01\u9650\u5236\u3002", (String)"PaymentImpl_15", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType());
    }
}

