/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HSBC_DC_Packer {
    public static Element createHead(String bizType) {
        return HSBC_DC_Packer.createHead(bizType, EBContext.getContext().getRequestSeqID());
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyy-MM-dd")));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HH-mm-ss")));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"token", (String)"");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public static String packDetail(BankDetailRequest request) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = HSBC_DC_Packer.createHead("DETAIL");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)"1");
        Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
        JDomUtils.addChild((Element)list, (String)"acntNo", (String)request.getHeader().getAcnt().getAccNo());
        JDomUtils.addChild((Element)list, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)list, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
        JDomUtils.addChild((Element)list, (String)"currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)list, (String)"txType", (String)"all");
        return JDomUtils.root2String((Element)simulator, (String)EBContext.getContext().getCharsetName());
    }
}

