/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service;

import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbc.dc.utils.FileTransUtil;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HSBC_DC_Parser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HSBC_DC_Parser.class);

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"HSBC_DC_Parser_0", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    public static EBBankDetailResponse parserDetail(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse bankDetailResponse = new EBBankDetailResponse();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = request.getHeader().getAcnt();
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = HSBC_DC_Parser.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25", (String)"HSBC_DC_Parser_1", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"HSBC_DC_Parser_2", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"BIZ_SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25", (String)"HSBC_DC_Parser_1", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        }
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            bankDetailResponse.setDetails(detailList);
            return bankDetailResponse;
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String acntNo = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"acntNo", (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"HSBC_DC_Parser_3", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            if (acnt.getAccNo().equalsIgnoreCase(acntNo)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\uff0c\u8fd4\u56de\u8d26\u53f7[%1$s]\u548c\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"HSBC_DC_Parser_20", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), acntNo, acnt.getAccNo()));
            }
            String txDate = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"txDate", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"HSBC_DC_Parser_7", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            String txTime = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"txTime", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4", (String)"HSBC_DC_Parser_8", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acnt.getAccNo());
            detail.setAccName(acnt.getAccName());
            detail.setBankName(acnt.getBankName());
            try {
                detail.setTransTime(LocalDateTime.parse(txDate + txTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u671f\u5f85\u8fd4\u56de\u683c\u5f0f\u4e3ayyyyMMddHHmmss\uff0c\u5b9e\u9645\u8fd4\u56de\u6570\u636e\u4e3a[%1$s%2$s]\u3002", (String)"HSBC_DC_Parser_21", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), txDate, txTime), (Throwable)e);
            }
            String cdFlag = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"cdFlag", (String)ResManager.loadKDString((String)"\u501f\u8d37\u6807\u8bc6", (String)"HSBC_DC_Parser_11", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            String Amount = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"txAmt", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"HSBC_DC_Parser_12", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            if ("CREDIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(new BigDecimal(Amount));
                detail.setDebitAmount(ParserUtils.ZERO);
            } else if ("DEBIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(ParserUtils.ZERO);
                detail.setDebitAmount(new BigDecimal(Amount));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u672a\u77e5\u7684'\u501f\u8d37\u6807\u5fd7':%s,\u65e0\u6cd5\u786e\u5b9a\u8be5\u7b14\u4ea4\u6613\u7684\u501f\u8d37\u7c7b\u578b\u3002", (String)"HSBC_DC_Parser_22", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), cdFlag));
            }
            String txCurrency = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"currency", (String)ResManager.loadKDString((String)"\u5e01\u79cd", (String)"HSBC_DC_Parser_15", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            detail.setCurrency(txCurrency);
            String balance = JDomUtils.getChildTextTrim((Element)list, (String)"balance");
            if (!balance.isEmpty()) {
                detail.setBalance(new BigDecimal(balance));
            }
            String oppAcntNo = JDomUtils.getChildTextTrim((Element)list, (String)"oppAcntNo");
            String oppAcntName = JDomUtils.getChildTextTrim((Element)list, (String)"oppAcntName");
            String oppBankName = JDomUtils.getChildTextTrim((Element)list, (String)"oppBankName");
            detail.setOppAccNo(oppAcntNo);
            detail.setOppAccName(oppAcntName);
            detail.setOppBankName(oppBankName);
            String explanination = JDomUtils.getChildTextTrim((Element)list, (String)"explanation");
            String releationId = JDomUtils.getChildTextTrim((Element)list, (String)"releationId");
            detail.setExplanation(explanination);
            detailList.add(detail);
        }
        bankDetailResponse.setDetails(detailList);
        return bankDetailResponse;
    }

    public static EBBankPayResponse parsePayResponse(BankPayRequest request, String responseStr) {
        if (PropertiesConstants.getValue((String)"SUCCESS").equalsIgnoreCase(responseStr)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.SUBMITTING, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_DC_Parser_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_DC_Parser_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_DC_Parser_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        } else if (PropertiesConstants.getValue((String)"FAIL").equalsIgnoreCase(responseStr)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"HSBC_DC_Parser_17", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"HSBC_DC_Parser_17", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u4e0a\u4f20\u5230\u94f6\u884c\u5931\u8d25\u3002", (String)"HSBC_DC_Parser_18", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"HSBC_DC_Parser_19", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"HSBC_DC_Parser_19", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"HSBC_DC_Parser_19", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public static EBBankPayResponse parseQueryPayResponse(BankPayRequest request, String responseStr) {
        File[] tarrFiles;
        File[] arrFiles;
        String[] ackDirs = StringUtils.split((String)responseStr, (String)"|");
        String ackDir = ackDirs[0];
        String transAckDir = ackDirs[1];
        File ackDirFile = FileCommonUtils.getFileByPath((String)ackDir);
        for (File file : arrFiles = ackDirFile.listFiles()) {
            String response = FileTransUtil.fileToString(file);
            Element root = JDomUtils.string2Root((String)response, (String)EBContext.getContext().getCharsetName());
            Element cstrpt = JDomUtils.getChildElementNotNull((Element)root, (String)"CstmrPmtStsRpt");
            Element grphdr = JDomUtils.getChildElementNotNull((Element)cstrpt, (String)"GrpHdr");
            String msgId = grphdr.getChildText("MsgId");
            Element orgnlpst = JDomUtils.getChildElementNotNull((Element)cstrpt, (String)"OrgnlPmtInfAndSts");
            String OrgnlPmtInfId = JDomUtils.getChildTextNotNull((Element)orgnlpst, (String)"OrgnlPmtInfId");
            List txinfList = orgnlpst.getChildren("TxInfAndSts");
            Map<String, String> resultMap = HSBC_DC_Parser.getResultMap(txinfList);
            List payInfoList = PaymentInfoService.getInstance().selectByBatchSeqID(OrgnlPmtInfId);
            for (PaymentInfo gen : payInfoList) {
                String status = resultMap.get(gen.getBankBatchSeqID());
                if (StringUtils.isEmpty((String)status)) continue;
                if ("RJCT".equalsIgnoreCase(status)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)gen, (PaymentState)PaymentState.FAIL, (String)"", (String)"", (String)"");
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)gen, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
            }
            if (FileTransUtil.cutFile(file, file.getParent())) {
                logger.info("\u79fb\u52a8\u6587\u4ef6\uff1a\u6210\u529f");
                continue;
            }
            logger.info("\u79fb\u52a8\u6587\u4ef6\uff1a\u5931\u8d25");
        }
        File transAckDirFile = FileCommonUtils.getFileByPath((String)transAckDir);
        for (File file : tarrFiles = transAckDirFile.listFiles()) {
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private static Map<String, String> getResultMap(List<Element> results) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        for (Element node : results) {
            String stsId = node.getChildText("OrgnlEndToEndId");
            String txStatus = node.getChildText("TxSts");
            resultMap.put(stsId, txStatus);
        }
        return resultMap;
    }
}

