/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Packer;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest request) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = HSBC_DC_Packer.createHead("DETAIL");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)"1");
        Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
        JDomUtils.addChild((Element)list, (String)"acntNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)list, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)list, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
        JDomUtils.addChild((Element)list, (String)"currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)list, (String)"txType", (String)"all");
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        BankAcnt acnt = request.getAcnt();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = HSBC_DC_Parser.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,%1$s,%2$s", (String)"DetailImpl_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"BIZ_SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,%1$s,%2$s", (String)"DetailImpl_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            return new EBBankDetailResponse(detailList);
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String acntNo = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"acntNo", (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"DetailImpl_2", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            if (!acnt.getAccNo().equalsIgnoreCase(acntNo)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\uff0c\u8fd4\u56de\u8d26\u53f7[%1$s]\u548c\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"DetailImpl_17", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), acntNo, acnt.getAccNo()));
            }
            String txDate = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"txDate", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_6", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            String txTime = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"txTime", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4", (String)"DetailImpl_7", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acnt.getAccNo());
            detail.setAccName(acnt.getAccName());
            detail.setBankName(acnt.getBankName());
            try {
                detail.setTransDate(LocalDate.parse(txDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                detail.setTransTime(LocalDateTime.parse(txDate + txTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u671f\u5f85\u8fd4\u56de\u683c\u5f0f(yyyyMMddHHmmss)\u6570\u636e\u548c\u5b9e\u9645\u8fd4\u56de\u6570\u636e[%1$s,%2$s]\u4e0d\u4e00\u81f4.", (String)"DetailImpl_18", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), txDate, txTime), (Throwable)e);
            }
            String cdFlag = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"cdFlag", (String)ResManager.loadKDString((String)"\u501f\u8d37\u6807\u8bc6", (String)"DetailImpl_10", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            String Amount = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"txAmt", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_11", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            if ("CREDIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(new BigDecimal(Amount));
                detail.setDebitAmount(BigDecimalHelper.ZERO);
            } else if ("DEBIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(BigDecimalHelper.ZERO);
                detail.setDebitAmount(new BigDecimal(Amount));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u672a\u77e5\u7684'\u501f\u8d37\u6807\u5fd7':%s,\u65e0\u6cd5\u786e\u5b9a\u8be5\u7b14\u4ea4\u6613\u7684\u501f\u8d37\u7c7b\u578b\u3002", (String)"DetailImpl_19", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), cdFlag));
            }
            String txCurrency = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"currency", (String)ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DetailImpl_14", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
            detail.setCurrency(txCurrency);
            String balance = JDomUtils.getChildTextTrim((Element)list, (String)"balance");
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            String oppAcntNo = JDomUtils.getChildTextTrim((Element)list, (String)"oppAcntNo");
            String oppAcntName = JDomUtils.getChildTextTrim((Element)list, (String)"oppAcntName");
            String oppBankName = JDomUtils.getChildTextTrim((Element)list, (String)"oppBankName");
            detail.setOppAccNo(oppAcntNo);
            detail.setOppAccName(oppAcntName);
            detail.setOppBankName(oppBankName);
            String explanination = JDomUtils.getChildTextTrim((Element)list, (String)"explanation");
            detail.setExplanation(explanination);
            String relationId = JDomUtils.getChildTextTrim((Element)list, (String)"relationId");
            String transType = JDomUtils.getChildTextTrim((Element)list, (String)"transType");
            if (!StringUtils.isEmpty((String)relationId) && !"NCHG".equalsIgnoreCase(transType)) {
                if (relationId.startsWith("kd") && relationId.length() == 10) {
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)relationId);
                    detail.setPayBankDetailSeqID(relationId);
                } else if (relationId.startsWith("akd") && relationId.length() == 11) {
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)relationId);
                    detail.setPayBankDetailSeqID(relationId);
                } else if (relationId.startsWith("pkd") && relationId.length() == 11) {
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)relationId);
                    detail.setPayBankDetailSeqID(relationId);
                }
            }
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DETAIL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6c47\u4e30\u94f6\u884c\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_15", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]);
    }
}

