/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ghb.dc.services.detail;

import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ghb.dc.services.utils.GHB_DC_Packer;
import kd.ebg.aqap.banks.ghb.dc.services.utils.GHB_DC_Parser;
import kd.ebg.aqap.banks.ghb.dc.services.utils.JDomUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest rqst) {
        BankAcnt bankAcnt = rqst.getAcnt();
        String transCode = "ZTSA63Q03";
        String encoding = RequestContextUtils.getCharset();
        LocalDate startDate = rqst.getStartDate();
        LocalDate endDate = rqst.getEndDate();
        Element root = GHB_DC_Packer.createHead(GHB_DC_Packer.getSeqNo(), transCode);
        JDomUtils.addChild((Element)root, (String)"ACCTNO", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)root, (String)"TOACCTNO", (String)"");
        JDomUtils.addChild((Element)root, (String)"TOACCTNAME", (String)"");
        JDomUtils.addChild((Element)root, (String)"RCVPAYFLAG", (String)"");
        JDomUtils.addChild((Element)root, (String)"MINTRNAMT", (String)"");
        JDomUtils.addChild((Element)root, (String)"MAXTRNAMT", (String)"");
        JDomUtils.addChild((Element)root, (String)"BGNDT", (String)LocalDateUtil.formatDate((LocalDate)startDate, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)root, (String)"ENDDT", (String)LocalDateUtil.formatDate((LocalDate)endDate, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)root, (String)"BGNROWNO", (String)"1");
        JDomUtils.addChild((Element)root, (String)"RQROWNUM", (String)"99999");
        JDomUtils.addChild((Element)root, (String)"ORDERTYPE", (String)"");
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        BankAcnt bankAcnt = rqst.getAcnt();
        Element root = GHB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = GHB_DC_Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)bankAcnt, (String)ResManager.loadKDString((String)"\u8d26\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]), (BankResponse)response, (String)"000000");
        String totalRowNumStr = ParserUtils.checkUnNullableElement((Element)root, (String)"TOTALROWNUM");
        ParserUtils.checkUnNullableElement((Element)root, (String)"RSROWNUM");
        int totalRowNum = Integer.parseInt(totalRowNumStr);
        if (totalRowNum == 0) {
            return new EBBankDetailResponse(detailList);
        }
        List list = root.getChildren("ROW");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detailInfo = new DetailInfo();
            Element row = (Element)list.get(i);
            String currency = ParserUtils.checkUnNullableElement((Element)row, (String)"CCY");
            String dc = ParserUtils.checkUnNullableElement((Element)row, (String)"DRCRFLAG");
            String amountStr = ParserUtils.checkUnNullableElement((Element)row, (String)"TRNAMT");
            String balanceStr = row.getChildText("ACCTBAL");
            boolean isExistOppoAcctNo = JDomUtil.checkDomExist(row, "OPPOACCTNO");
            String oppAccNo = "";
            String oppAccName = "";
            if (isExistOppoAcctNo) {
                oppAccNo = ParserUtils.getUnNullElementTextValue((Element)row, (String)"OPPOACCTNO", (String)"");
                oppAccName = ParserUtils.getUnNullElementTextValue((Element)row, (String)"OPPOACCTNAME", (String)"");
            }
            String explanation = ParserUtils.checkUnNullableElement((Element)row, (String)"MEMO");
            String transDateStr = ParserUtils.checkUnNullableElement((Element)row, (String)"TRNDT");
            String hostSeqno = ParserUtils.checkUnNullableElement((Element)row, (String)"HOSTSEQNO");
            BigDecimal amount = null;
            if (StringUtils.isEmpty((String)amountStr)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e7f\u4e1c\u534e\u5174\u94f6\u884c\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]));
            }
            amount = new BigDecimal(amountStr.trim());
            detailInfo.setCurrency(currency);
            if (dc.equals("D")) {
                detailInfo.setDebitAmount(amount);
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
            } else if (dc.equals("C")) {
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
                detailInfo.setCreditAmount(amount);
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u501f\u8d37\u6807\u8bc6\u8fd4\u56de\u6709\u8bef", (String)"DetailImpl_12", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]));
            }
            detailInfo.setOppAccNo(oppAccNo);
            detailInfo.setOppAccName(oppAccName);
            detailInfo.setExplanation(explanation);
            detailInfo.setTransDate(LocalDateUtil.parserDate((String)transDateStr.trim(), (String)"yyyyMMdd"));
            try {
                Date transDateTime = DateTimeUtils.parseDate((String)transDateStr.trim(), (String)"yyyyMMdd");
                detailInfo.setTransTime(transDateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u4ea4\u6613\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38:", (String)"DetailImpl_2", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]) + e.getMessage()), (Throwable)e);
            }
            if (!StringUtils.isEmpty((String)balanceStr)) {
                detailInfo.setBalance(new BigDecimal(balanceStr.trim()));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(hostSeqno);
            String receiptNo = MatchRule.getInstance().getReceiptNo(rqst.getAcnt().getAccNo(), transDateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailList.add(detailInfo);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "ZTSA63Q03";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u660e\u7ec6\uff0c\u5305\u62ec\u5386\u53f2\u660e\u7ec6\u548c\u5f53\u65e5\u660e\u7ec6\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/ghbankgayway4ent/rest/gayway";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "application/xml; charset=UTF-8");
        super.configFactory(factory);
    }
}

