/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tfyh.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tfyh.dc.services.Packer;
import kd.ebg.aqap.banks.tfyh.dc.services.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        Element root = Packer.buildTranHead("QueryDtl", Sequence.genSequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element entity = JDomUtils.addChild((Element)body, (String)"entity");
        String curSign = bankDetailRequest.getStartDate().isBefore(LocalDate.now()) ? "1" : "0";
        JDomUtils.addChild((Element)entity, (String)"curSign", (String)curSign);
        JDomUtils.addChild((Element)entity, (String)"accountCode", (String)accNo);
        JDomUtils.addChild((Element)entity, (String)"startDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)entity, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)entity, (String)"pageCount", (String)"50");
        String currentPage = this.getCurrentPage();
        int page = currentPage.equals("0") ? 1 : Integer.parseInt(currentPage);
        this.setCurrentPage(page + 1);
        JDomUtils.addChild((Element)entity, (String)"pageNo", (String)(page + ""));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = Parser.parser(root);
        if (!StringUtils.isEmpty((String)bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        Element body = root.getChild("body");
        Element entity = JDomUtils.getChildElement((Element)body, (String)"entity");
        if ("1".equals(JDomUtils.getChildText((Element)entity, (String)"retCode"))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), JDomUtils.getChildText((Element)entity, (String)"retMsg")));
        }
        List list = body.getChildren("list");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        for (int i = 0; i < list.size(); ++i) {
            LocalDateTime transTime;
            Element record = (Element)list.get(i);
            if (!acnt.getAccNo().equals(record.getChildTextTrim("accountCode"))) continue;
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(bankDetailRequest.getBankCurrency());
            detail.setOppAccNo(JDomUtils.getChildText((Element)record, (String)"otherAccount"));
            detail.setOppAccName(JDomUtils.getChildText((Element)record, (String)"otherName"));
            detail.setOppBankName(JDomUtils.getChildText((Element)record, (String)"otherDeposit"));
            detail.setAccName(JDomUtils.getChildText((Element)record, (String)"accountName"));
            detail.setAccNo(JDomUtils.getChildText((Element)record, (String)"accountCode"));
            String transferTime = JDomUtils.getChildText((Element)record, (String)"tradeTime");
            try {
                transTime = LocalDateTime.parse(transferTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S"));
            }
            catch (Exception ignore) {
                transTime = LocalDateTime.parse(transferTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            detail.setTransTime(transTime);
            detail.setTransDate(transTime.toLocalDate());
            BigDecimal amount = new BigDecimal(JDomUtils.getChildText((Element)record, (String)"tradeMoney"));
            String tradeSign = JDomUtils.getChildText((Element)record, (String)"tradeSign");
            if (tradeSign.equalsIgnoreCase("1")) {
                detail.setDebitAmount(amount);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (tradeSign.equalsIgnoreCase("0")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(amount);
            }
            detail.setExplanation(JDomUtils.getChildText((Element)record, (String)"tradeSummary"));
            detail.setBalance(new BigDecimal(JDomUtils.getChildTextTrim((Element)record, (String)"remainMoney")));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(record.getChildTextTrim("detailCode"));
            detailList.add(detail);
        }
        String nextFlag = JDomUtils.getChildText((Element)entity, (String)"nextFlag");
        if (!StringUtils.isEmpty((String)nextFlag) && "0".equalsIgnoreCase(nextFlag)) {
            this.setLastPage(false);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isSupportPage() {
        return true;
    }
}

