/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hrb.dc.service.payment.outer;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hrb.dc.service.payment.outer.PayPacker;
import kd.ebg.aqap.banks.hrb.dc.service.payment.outer.PayParser;
import kd.ebg.aqap.banks.hrb.dc.service.payment.outer.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !paymentInfo.is2SameBank();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PayPacker payPacker = new PayPacker();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        return payPacker.packPay(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/corplink/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rsp) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PayParser payParser = new PayParser();
        payParser.parsePay(paymentInfos, rsp);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "xs";
    }

    public String getBizCode() {
        return "CBE004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"PayImpl_11", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]);
    }
}

