/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.payment.samebank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.glb.dc.services.payment.samebank.QryTransferSameBankImpl;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBPacker;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBStringUtils;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBTransferParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TransferSameBankImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TransferSameBankImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryTransferSameBankImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"CBE020100\u884c\u5185\u8f6c\u8d26\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"TransferSameBankImpl_0", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(this.getBizCode()));
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payAccountName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"payAmount", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"currencyType", (String)paymentInfo.getCurrency());
        String Summary = paymentInfo.getExplanation();
        if (!StringUtils.isEmpty((String)Summary) && Summary.length() > 60) {
            Summary = Summary.substring(0, 60);
        }
        if (StringUtils.isEmpty((String)Summary)) {
            Summary = ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u8f6c\u8d26", (String)"TransferSameBankImpl_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]);
        }
        JDomUtils.addChild((Element)body, (String)"payRem", (String)Summary);
        JDomUtils.addChild((Element)body, (String)"businessCode", (String)"020100");
        JDomUtils.addChild((Element)body, (String)"recBankType", (String)"0");
        JDomUtils.addChild((Element)body, (String)"confirmCode", (String)"9999");
        if (paymentInfo.is2Individual()) {
            JDomUtils.addChild((Element)body, (String)"pubPriFlag", (String)"1");
        } else {
            JDomUtils.addChild((Element)body, (String)"pubPriFlag", (String)"0");
        }
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        GLBTransferParser.parseTransfer(paymentInfos, s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "wenhao_zhong";
    }

    public String getBizCode() {
        return "CBE020100";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"TransferSameBankImpl_2", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }
}

