/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boimc.dc.service.payment;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boimc.dc.service.ResponseChecker;
import kd.ebg.aqap.banks.boimc.dc.service.utils.DateFormatter;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BankCrossQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankCrossQueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "B2ETrsResultQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u4ed8\u6b3e", (String)"BankCrossQueryPayImpl_0", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String packageId = paymentInfos[0].getPackageId();
        if (packageId == null || "".equals(packageId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4fe1\u606f\u7f3a\u5c11\u6d41\u6c34\u53f7\u3002", (String)"BankCrossQueryPayImpl_1", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        }
        Element message = new Element("Message");
        Element head = new Element("Head");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2ETrsResultQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateFormatter.format2DateTime(new Date()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)message, (Element)body);
        this.logger.info("\u4ed8\u6b3e\u4ea4\u6613\u6d41\u6c34\u53f7\uff1a" + packageId);
        JDomUtils.addChild((Element)body, (String)"HistoryERPJnlNo", (String)packageId);
        JDomUtils.addChild((Element)body, (String)"TransDate", (String)DateFormatter.format2Date(paymentInfos[0].getSubmitSuccessTime()));
        this.logger.info("\u4ea4\u6613\u65e5\u671f\uff1a" + paymentInfos[0].getSubmitSuccessTime());
        return JDomUtils.root2String((Element)message, (String)"GBK");
    }

    public EBBankPayResponse parse(BankPayRequest request, String resp) {
        List paymentInfos = request.getPaymentInfos();
        Element message = JDomUtils.string2Root((String)resp, (String)"GBK");
        ResponseChecker.checkResponse(paymentInfos, message, ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u4e1a\u52a1", (String)"BankCrossQueryPayImpl_2", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"List");
        Element map = JDomUtils.getChildElement((Element)list, (String)"Map");
        String returnCode = JDomUtils.getChildTextNotNull((Element)map, (String)"ReturnCode");
        String returnMsg = JDomUtils.getChildText((Element)map, (String)"ReturnMsg");
        String trsStateCode = JDomUtils.getChildTextNotNull((Element)map, (String)"TrsStateCode");
        if ("000000".equals(returnCode)) {
            if ("0".equals(trsStateCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)trsStateCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BankCrossQueryPayImpl_3", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
                this.logger.info("\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u6210\u529f\u4fe1\u606f\uff0c\u4ea4\u6613\u72b6\u6001\u7801\uff1a" + trsStateCode + ", \u8fd4\u56de\u4fe1\u606f\uff1a" + returnMsg);
            } else if ("1".equals(trsStateCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)trsStateCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BankCrossQueryPayImpl_4", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
                this.logger.info("\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u5931\u8d25\u4fe1\u606f\uff0c\u4ea4\u6613\u72b6\u6001\u7801\uff1a" + trsStateCode + ", \u8fd4\u56de\u4fe1\u606f\uff1a\u4ea4\u6613\u5931\u8d25");
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)trsStateCode, (String)returnMsg);
                this.logger.info("\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u4ea4\u6613\u72b6\u6001\u7801\uff1a" + trsStateCode + ", \u8fd4\u56de\u4fe1\u606f\uff1a" + returnMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

