/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.detail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.zsb.dc.services.detail.DetailFileReceiveImpl;
import kd.ebg.aqap.banks.zsb.dc.services.proxy.DetailFileProxy;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ResponseFileUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ResponseFileUtils.class);

    public static String[] getDetailRspRecords(String fileName) throws EBServiceException {
        String detailContent = "";
        long waiting4DataTime = Long.parseLong(RequestContextUtils.getBankParameterValue((String)"waiting4Data"));
        try {
            Thread.currentThread();
            Thread.sleep(waiting4DataTime);
        }
        catch (InterruptedException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        String method = BankBusinessConfig.getFileMethod();
        if ("1".equalsIgnoreCase(method)) {
            detailContent = new DetailFileProxy().getContent(fileName);
        } else if ("2".equalsIgnoreCase(method)) {
            detailContent = ResponseFileUtils.getDetailFileFromHttp(fileName);
        }
        logger.info("detail Content:" + detailContent);
        String[] records = StringUtils.split((String)detailContent, (String)"|");
        return records;
    }

    private static String getDetailFileFromHttp(String fileName) throws EBServiceException {
        String host = RequestContextUtils.getBankParameterValue((String)"ip");
        int port = Integer.parseInt(RequestContextUtils.getBankParameterValue((String)"httpPort"));
        int timeout = Integer.parseInt(RequestContextUtils.getBankParameterValue((String)"timeout"));
        String filePath = RequestContextUtils.getBankParameterValue((String)"filePath");
        InputStreamReader reader = null;
        try {
            DetailFileReceiveImpl receiver = new DetailFileReceiveImpl();
            String address = "http://" + host + ":" + port + "/banks/" + "ZSB_DC" + "?path=" + URLEncoder.encode(filePath, "UTF-8") + "&fileName=" + URLEncoder.encode(fileName, "UTF-8");
            InputStream is = receiver.doBiz(address);
            reader = new InputStreamReader(is, "GBK");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader bfReader = new BufferedReader(reader);
        try {
            String line = null;
            while ((line = bfReader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u94f6\u884c\u8fd4\u56de\u7684\u5e94\u7b54\u6587\u4ef6\u51fa\u9519%s\u3002", (String)"ResponseFileUtils_1", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }
}

