/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccqtgb.dc.services.payment.batch;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.BankCode;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.DC_RequestPacker;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.DC_ResponseParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBatchPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBatchPayImpl.class);

    public int getBatchSize() {
        return 400;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfoArray = bankPayRequest.getPaymentInfos();
        if (StringUtils.isEmpty((String)((PaymentInfo)paymentInfoArray.get(0)).getBankRefID())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u65f6\uff0c\u94f6\u884c\u672a\u8fd4\u56de\u6279\u6b21\u53f7\uff0c\u65e0\u6cd5\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"QueryBatchPayImpl_0", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]));
        }
        Element message = new Element("Message");
        Element head = DC_RequestPacker.createCommonHead(this.getBizCode(), ((PaymentInfo)paymentInfoArray.get(0)).getBankBatchSeqID());
        Element body = new Element("Body");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        Element list = new Element("List");
        JDomUtils.addChild((Element)body, (Element)list);
        Element map = new Element("Map");
        JDomUtils.addChild((Element)list, (Element)map);
        JDomUtils.addChild((Element)map, (String)"BatchNo", (String)((PaymentInfo)paymentInfoArray.get(0)).getBankRefID());
        JDomUtils.addChild((Element)map, (String)"AcctNo", (String)((PaymentInfo)paymentInfoArray.get(0)).getAccNo());
        JDomUtils.addChild((Element)map, (String)"ReservedField1", (String)"");
        JDomUtils.addChild((Element)map, (String)"ReservedField2", (String)"");
        JDomUtils.addChild((Element)map, (String)"ReservedField3", (String)"");
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse response = DC_ResponseParser.parserCommonHead(rspStr);
        if (!BankCode.SUCCESS_CODE.equals(response.getResponseCode())) {
            this.logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5916\u5c42\u72b6\u6001\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"QueryBatchPayImpl_1", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element bodyEle = root.getChild("Body");
        Element list = bodyEle.getChild("List");
        Element map = list.getChild("Map");
        String ReturnCode = map.getChildText("ReturnCode");
        String ReturnMsg = map.getChildText("ReturnMsg");
        Element list2 = map.getChild("List");
        if (list2 != null) {
            List maps = list2.getChildren("Map");
            if (CollectionUtil.isNotEmpty((Collection)maps)) {
                HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>(paymentInfos.size());
                for (PaymentInfo paymentInfo : paymentInfos) {
                    paymentInfoMap.put(paymentInfo.getSys("Number"), paymentInfo);
                }
                for (Element element : maps) {
                    String Number2 = element.getChildText("Number");
                    String TranStatus = element.getChildText("TranStatus");
                    String TranRspMsg = element.getChildText("TranRspMsg");
                    PaymentInfo paymentInfo = (PaymentInfo)paymentInfoMap.get(Number2);
                    if (paymentInfo == null) {
                        this.logger.info("\u672a\u627e\u5230\u5e8f\u53f7\u4e3a{}\u7684\u94f6\u4f01\u4e91\u4ed8\u6b3e\u8bb0\u5f55", (Object)Number2);
                        continue;
                    }
                    if ("0".equals(TranStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)TranStatus, (String)TranRspMsg);
                        continue;
                    }
                    if ("1".equals(TranStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)TranStatus, (String)"");
                        continue;
                    }
                    if ("6".equals(TranStatus)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)TranStatus, (String)TranRspMsg);
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)TranStatus, (String)TranRspMsg);
                }
            } else {
                this.logger.info("\u5faa\u73af\u4f53\u4e2dMap\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u72b6\u6001\uff0c\u6682\u4e0d\u5904\u7406");
            }
        } else {
            this.logger.info("\u5faa\u73af\u4f53\u8fd4\u56de\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u72b6\u6001\uff0c\u6682\u4e0d\u5904\u7406");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return BankCode.QUERY_BATCHCROSSBANK_TRANS_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u6279\u91cf\u4ed8\u6b3e\u7ed3\u679c", (String)"QueryBatchPayImpl_2", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]);
    }
}

