/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.cmp.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.PackHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.ParserHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        return this.packRequest(bankBalanceRequest);
    }

    private String packRequest(BankBalanceRequest bankBalanceRequest) {
        Element body = JDomUtils.createRoot((String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)bankBalanceRequest.getBankCurrency());
        return PackHelper.getPackMessage("01603020101A0008", Sequence.genSequence(), body);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return this.parseResponse(bankBalanceRequest, s);
    }

    private EBBankBalanceResponse parseResponse(BankBalanceRequest bankBalanceRequest, String res) {
        ParserHelper.judgeHeadMessage(res);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = this.getBalance(bankBalanceRequest, res);
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>();
        balanceInfos.add(balanceInfo);
        bankBalanceResponse.setBalances(balanceInfos);
        return bankBalanceResponse;
    }

    private BalanceInfo getBalance(BankBalanceRequest bankBalanceRequest, String res) {
        BalanceInfo balanceInfo = new BalanceInfo();
        Element body = ParserHelper.getBodyMessage(res);
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        String balance = body.getChildText("bookBal");
        balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
        String availBal = body.getChildText("avaliableBal");
        balanceInfo.setAvailableBalance(BigDecimalHelper.str2BigDecimalForBalance((String)availBal, (Boolean)true));
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return balanceInfo;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "01603020101A0008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

