/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jsb.cmp.service.balance;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jsb.cmp.service.BankBusinessConfig;
import kd.ebg.aqap.banks.jsb.cmp.service.balance.GJTodayBalanceImpl;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Packer;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead("00003020101A0008", Sequence.gen14Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"currency", (String)request.getBankCurrency());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element dto = JDomUtils.getChildElement((Element)root, (String)"body").getChild("dto");
        String balance = dto.getChildTextTrim("bookBal");
        String use_balance = dto.getChildTextTrim("avaliableBal");
        if (BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo())) {
            GJTodayBalanceImpl impl = new GJTodayBalanceImpl();
            EBBankBalanceResponse ebBankBalanceResponse = impl.doBiz(request);
            use_balance = ((BalanceInfo)ebBankBalanceResponse.getBalances().get(0)).getAvailableBalance().toPlainString();
        }
        String freeze_bal = dto.getChildTextTrim("frzBal");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (StringUtils.isEmpty((String)balance)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d\u8fd4\u56de\u4e3a\u7a7a", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]));
        }
        balanceInfo.setCurrentBalance(new BigDecimal(balance));
        if (!StringUtils.isEmpty((String)use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "03020101A0008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5f53\u524d\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }
}

