/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jsb.cmp.service.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packer {
    private static final Logger logger = LoggerFactory.getLogger(Packer.class);

    public static Element buildHead(String trsCode, String seqNo) {
        return Packer.buildHead(trsCode, seqNo, "0", "0");
    }

    public static Element buildHead(String trsCode, String seqNo, String sign, String fileFlag) {
        Element root = new Element("ap");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)trsCode);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"cms_corp_no"));
        JDomUtils.addChild((Element)head, (String)"user_no", (String)RequestContextUtils.getBankParameterValue((String)"user_no"));
        JDomUtils.addChild((Element)head, (String)"org_code", (String)RequestContextUtils.getBankParameterValue((String)"org_code"));
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)seqNo);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"18");
        JDomUtils.addChild((Element)head, (String)"sign", (String)sign);
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)fileFlag);
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        JDomUtils.addChild((Element)root, (String)"body");
        return root;
    }

    public static String buildCommonMsg(String xmlStr) {
        int length = Packer.getLength(xmlStr);
        StringBuilder buffer = new StringBuilder();
        buffer.append(Packer.formatLen(Integer.toString(length + 2), 10));
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    public static String formatLen(String orgStr, int exptecedLength) {
        try {
            String encoding = RequestContextUtils.getCharset();
            return StringFormater.formatLen((String)orgStr, (int)exptecedLength, (boolean)true, (char)'0', (String)encoding);
        }
        catch (Exception e) {
            logger.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Throwable)e);
            return "";
        }
    }

    public static int getLength(String msg) {
        String encoding = RequestContextUtils.getCharset();
        try {
            int length = msg.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519\uff0c", (Throwable)e);
            return 0;
        }
    }
}

