/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xjnx.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xjnx.dc.service.util.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final int turnPageShowNum = 10;

    public String pack(BankDetailRequest rqst) {
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            this.setCurrentPage("1");
        }
        return Packer.getHead() + "accountNo=" + rqst.getAcnt().getAccNo() + "&beginDate=" + LocalDateUtil.formatDate((LocalDate)rqst.getStartDate()) + "&endDate=" + LocalDateUtil.formatDate((LocalDate)rqst.getEndDate()) + "&pageNo=" + this.getCurrentPage();
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element ebenk = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        String total = ebenk.getChildTextTrim("turnPageTotalNum");
        if (StringUtils.isEmpty((String)total)) {
            this.setLastPage(true);
        } else {
            int turnPageTotalNum = Integer.parseInt(total);
            int pagetag = Integer.parseInt(this.getCurrentPage());
            if (pagetag * 10 >= turnPageTotalNum) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
                this.setCurrentPage(pagetag + 1);
            }
        }
        String retCode = ebenk.getChildTextTrim("retCode");
        if ("DPS942".equals(retCode)) {
            return new EBBankDetailResponse(detailList);
        }
        if (!"000000".equals(retCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38 :%s", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-xjnx-dc", (Object[])new Object[0]), ebenk.getChildText("ebg-aqap-banks-xjnx-dc")));
        }
        Element listElement = ebenk.getChild("list");
        List list = listElement.getChildren("row");
        if (list.size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        for (Element row : list) {
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(row.getChildTextTrim("currencyType"));
            detail.setOppAccNo(row.getChildTextTrim("opponencyAccount"));
            detail.setOppAccName(row.getChildTextTrim("opponencyacctName"));
            String transferDate = row.getChildTextTrim("transferDate");
            detail.setTransDate(LocalDateUtil.parserDate((String)transferDate));
            LocalDateTime transTime = LocalDateUtil.parseDateTime((String)transferDate);
            detail.setTransTime(transTime);
            String tranAmt = row.getChildTextTrim("tranAmt");
            String debitCreditCode = row.getChildTextTrim("debitCreditCode");
            if ("C".equals(debitCreditCode)) {
                detail.setCreditAmount(new BigDecimal(tranAmt));
                detail.setDebitAmount(BigDecimal.ZERO);
            } else if ("D".equals(debitCreditCode)) {
                detail.setCreditAmount(BigDecimal.ZERO);
                detail.setDebitAmount(new BigDecimal(tranAmt));
            }
            String balance = row.getChildTextTrim("balance");
            detail.setBalance(new BigDecimal(balance));
            String transferFlowNo = row.getChildTextTrim("transferFlowNo");
            detail.setBankDetailNo(transferFlowNo);
            String remark = row.getChildTextTrim("remark");
            detail.setExplanation(remark);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "YQqryHostDetailAction";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        String uri = RequestContextUtils.getBankParameterValue((String)"xjnx_uri");
        factory.setUri(uri + "/YQqryHostDetailAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

